/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.numerus;

import com.netflix.numerus.LongAdder;
import com.netflix.numerus.LongMaxUpdater;
import com.netflix.numerus.NumerusProperty;
import com.netflix.numerus.NumerusRollingNumberEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

public class NumerusRollingNumber {
    private static final Time ACTUAL_TIME = new ActualTime();
    private final Time time;
    final NumerusProperty<Integer> timeInMilliseconds;
    final NumerusProperty<Integer> numberOfBuckets;
    final BucketCircularArray buckets;
    private final CumulativeSum cumulativeSum;
    private final NumerusRollingNumberEvent events;
    private ReentrantLock newBucketLock = new ReentrantLock();

    public NumerusRollingNumber(NumerusRollingNumberEvent events, NumerusProperty<Integer> timeInMilliseconds, NumerusProperty<Integer> numberOfBuckets) {
        this(events, ACTUAL_TIME, timeInMilliseconds, numberOfBuckets);
    }

    NumerusRollingNumber(NumerusRollingNumberEvent events, Time time2, int timeInMilliseconds, int numberOfBuckets) {
        this(events, time2, NumerusProperty.Factory.asProperty(timeInMilliseconds), NumerusProperty.Factory.asProperty(numberOfBuckets));
    }

    private NumerusRollingNumber(NumerusRollingNumberEvent events, Time time2, NumerusProperty<Integer> timeInMilliseconds, NumerusProperty<Integer> numberOfBuckets) {
        this.events = events;
        this.time = time2;
        this.timeInMilliseconds = timeInMilliseconds;
        this.numberOfBuckets = numberOfBuckets;
        this.cumulativeSum = new CumulativeSum(events);
        if (timeInMilliseconds.get() % numberOfBuckets.get() != 0) {
            throw new IllegalArgumentException("The timeInMilliseconds must divide equally into numberOfBuckets. For example 1000/10 is ok, 1000/11 is not.");
        }
        this.buckets = new BucketCircularArray(numberOfBuckets.get());
    }

    int getBucketSizeInMilliseconds() {
        return this.timeInMilliseconds.get() / this.numberOfBuckets.get();
    }

    public void increment(NumerusRollingNumberEvent type2) {
        this.getCurrentBucket().getAdder(type2).increment();
    }

    public void add(NumerusRollingNumberEvent type2, long value) {
        this.getCurrentBucket().getAdder(type2).add(value);
    }

    public void updateRollingMax(NumerusRollingNumberEvent type2, long value) {
        this.getCurrentBucket().getMaxUpdater(type2).update(value);
    }

    public void reset() {
        Bucket lastBucket = this.buckets.peekLast();
        if (lastBucket != null) {
            this.cumulativeSum.addBucket(lastBucket);
        }
        this.buckets.clear();
    }

    public long getCumulativeSum(NumerusRollingNumberEvent type2) {
        return this.getValueOfLatestBucket(type2) + this.cumulativeSum.get(type2);
    }

    public long getRollingSum(NumerusRollingNumberEvent type2) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return 0L;
        }
        long sum = 0L;
        for (Bucket b : this.buckets) {
            sum += b.getAdder(type2).sum();
        }
        return sum;
    }

    public long getValueOfLatestBucket(NumerusRollingNumberEvent type2) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return 0L;
        }
        return lastBucket.get(type2);
    }

    public long[] getValues(NumerusRollingNumberEvent type2) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return new long[0];
        }
        Bucket[] bucketArray = this.buckets.getArray();
        long[] values = new long[bucketArray.length];
        int i = 0;
        for (Bucket bucket : bucketArray) {
            if (type2.isCounter()) {
                values[i++] = bucket.getAdder(type2).sum();
                continue;
            }
            if (!type2.isMaxUpdater()) continue;
            values[i++] = bucket.getMaxUpdater(type2).max();
        }
        return values;
    }

    public long getRollingMaxValue(NumerusRollingNumberEvent type2) {
        long[] values = this.getValues(type2);
        if (values.length == 0) {
            return 0L;
        }
        Arrays.sort(values);
        return values[values.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bucket getCurrentBucket() {
        long currentTime = this.time.getCurrentTimeInMillis();
        Bucket currentBucket = this.buckets.peekLast();
        if (currentBucket != null && currentTime < currentBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) {
            return currentBucket;
        }
        if (this.newBucketLock.tryLock()) {
            try {
                if (this.buckets.peekLast() == null) {
                    Bucket newBucket = new Bucket(this.events, currentTime);
                    this.buckets.addLast(newBucket);
                    Bucket bucket = newBucket;
                    return bucket;
                }
                for (int i = 0; i < this.numberOfBuckets.get(); ++i) {
                    Bucket lastBucket = this.buckets.peekLast();
                    if (currentTime < lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) {
                        Bucket bucket = lastBucket;
                        return bucket;
                    }
                    if (currentTime - (lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) > (long)this.timeInMilliseconds.get().intValue()) {
                        this.reset();
                        Bucket bucket = this.getCurrentBucket();
                        return bucket;
                    }
                    this.buckets.addLast(new Bucket(this.events, lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()));
                    this.cumulativeSum.addBucket(lastBucket);
                }
                Bucket i = this.buckets.peekLast();
                return i;
            }
            finally {
                this.newBucketLock.unlock();
            }
        }
        currentBucket = this.buckets.peekLast();
        if (currentBucket != null) {
            return currentBucket;
        }
        try {
            Thread.sleep(5L);
        }
        catch (Exception e2) {
            // empty catch block
        }
        return this.getCurrentBucket();
    }

    class BucketCircularArray
    implements Iterable<Bucket> {
        private final AtomicReference<ListState> state;
        private final int dataLength;
        private final int numBuckets;

        BucketCircularArray(int size) {
            AtomicReferenceArray _buckets = new AtomicReferenceArray(size + 1);
            this.state = new AtomicReference<ListState>(new ListState(_buckets, 0, 0));
            this.dataLength = _buckets.length();
            this.numBuckets = size;
        }

        public void clear() {
            ListState newState;
            ListState current;
            while (!this.state.compareAndSet(current = this.state.get(), newState = current.clear())) {
            }
        }

        @Override
        public Iterator<Bucket> iterator() {
            return Collections.unmodifiableList(Arrays.asList(this.getArray())).iterator();
        }

        public void addLast(Bucket o) {
            ListState newState;
            ListState currentState = this.state.get();
            if (this.state.compareAndSet(currentState, newState = currentState.addBucket(o))) {
                return;
            }
        }

        public Bucket getLast() {
            return this.peekLast();
        }

        public int size() {
            return this.state.get().size;
        }

        public Bucket peekLast() {
            return this.state.get().tail();
        }

        private Bucket[] getArray() {
            return this.state.get().getArray();
        }

        private class ListState {
            private final AtomicReferenceArray<Bucket> data;
            private final int size;
            private final int tail;
            private final int head;

            private ListState(AtomicReferenceArray<Bucket> data2, int head, int tail) {
                this.head = head;
                this.tail = tail;
                this.size = head == 0 && tail == 0 ? 0 : (tail + BucketCircularArray.this.dataLength - head) % BucketCircularArray.this.dataLength;
                this.data = data2;
            }

            public Bucket tail() {
                if (this.size == 0) {
                    return null;
                }
                return this.data.get(this.convert(this.size - 1));
            }

            private Bucket[] getArray() {
                ArrayList<Bucket> array2 = new ArrayList<Bucket>();
                for (int i = 0; i < this.size; ++i) {
                    array2.add(this.data.get(this.convert(i)));
                }
                return array2.toArray(new Bucket[array2.size()]);
            }

            private ListState incrementTail() {
                if (this.size == BucketCircularArray.this.numBuckets) {
                    return new ListState(this.data, (this.head + 1) % BucketCircularArray.this.dataLength, (this.tail + 1) % BucketCircularArray.this.dataLength);
                }
                return new ListState(this.data, this.head, (this.tail + 1) % BucketCircularArray.this.dataLength);
            }

            public ListState clear() {
                return new ListState(new AtomicReferenceArray<Bucket>(BucketCircularArray.this.dataLength), 0, 0);
            }

            public ListState addBucket(Bucket b) {
                this.data.set(this.tail, b);
                return this.incrementTail();
            }

            private int convert(int index2) {
                return (index2 + this.head) % BucketCircularArray.this.dataLength;
            }
        }
    }

    static class CumulativeSum {
        final LongAdder[] adderForCounterType;
        final LongMaxUpdater[] updaterForCounterType;
        final NumerusRollingNumberEvent event;

        CumulativeSum(NumerusRollingNumberEvent event) {
            this.event = event;
            this.adderForCounterType = new LongAdder[event.getValues().length];
            for (NumerusRollingNumberEvent type2 : event.getValues()) {
                if (!type2.isCounter()) continue;
                this.adderForCounterType[type2.ordinal()] = new LongAdder();
            }
            this.updaterForCounterType = new LongMaxUpdater[event.getValues().length];
            for (NumerusRollingNumberEvent type2 : event.getValues()) {
                if (!type2.isMaxUpdater()) continue;
                this.updaterForCounterType[type2.ordinal()] = new LongMaxUpdater();
                this.updaterForCounterType[type2.ordinal()].update(0L);
            }
        }

        public void addBucket(Bucket lastBucket) {
            for (NumerusRollingNumberEvent type2 : this.event.getValues()) {
                if (type2.isCounter()) {
                    this.getAdder(type2).add(lastBucket.getAdder(type2).sum());
                }
                if (!type2.isMaxUpdater()) continue;
                this.getMaxUpdater(type2).update(lastBucket.getMaxUpdater(type2).max());
            }
        }

        long get(NumerusRollingNumberEvent type2) {
            if (type2.isCounter()) {
                return this.adderForCounterType[type2.ordinal()].sum();
            }
            if (type2.isMaxUpdater()) {
                return this.updaterForCounterType[type2.ordinal()].max();
            }
            throw new IllegalStateException("Unknown type of event: " + type2.name());
        }

        LongAdder getAdder(NumerusRollingNumberEvent type2) {
            if (!type2.isCounter()) {
                throw new IllegalStateException("Type is not a Counter: " + type2.name());
            }
            return this.adderForCounterType[type2.ordinal()];
        }

        LongMaxUpdater getMaxUpdater(NumerusRollingNumberEvent type2) {
            if (!type2.isMaxUpdater()) {
                throw new IllegalStateException("Type is not a MaxUpdater: " + type2.name());
            }
            return this.updaterForCounterType[type2.ordinal()];
        }
    }

    static class Bucket {
        final long windowStart;
        final LongAdder[] adderForCounterType;
        final LongMaxUpdater[] updaterForCounterType;

        Bucket(NumerusRollingNumberEvent events, long startTime) {
            this.windowStart = startTime;
            this.adderForCounterType = new LongAdder[events.getValues().length];
            for (NumerusRollingNumberEvent type2 : events.getValues()) {
                if (!type2.isCounter()) continue;
                this.adderForCounterType[type2.ordinal()] = new LongAdder();
            }
            this.updaterForCounterType = new LongMaxUpdater[events.getValues().length];
            for (NumerusRollingNumberEvent type2 : events.getValues()) {
                if (!type2.isMaxUpdater()) continue;
                this.updaterForCounterType[type2.ordinal()] = new LongMaxUpdater();
                this.updaterForCounterType[type2.ordinal()].update(0L);
            }
        }

        long get(NumerusRollingNumberEvent type2) {
            if (type2.isCounter()) {
                return this.adderForCounterType[type2.ordinal()].sum();
            }
            if (type2.isMaxUpdater()) {
                return this.updaterForCounterType[type2.ordinal()].max();
            }
            throw new IllegalStateException("Unknown type of event: " + type2.name());
        }

        LongAdder getAdder(NumerusRollingNumberEvent type2) {
            if (!type2.isCounter()) {
                throw new IllegalStateException("Type is not a Counter: " + type2.name());
            }
            return this.adderForCounterType[type2.ordinal()];
        }

        LongMaxUpdater getMaxUpdater(NumerusRollingNumberEvent type2) {
            if (!type2.isMaxUpdater()) {
                throw new IllegalStateException("Type is not a MaxUpdater: " + type2.name());
            }
            return this.updaterForCounterType[type2.ordinal()];
        }
    }

    private static class ActualTime
    implements Time {
        private ActualTime() {
        }

        @Override
        public long getCurrentTimeInMillis() {
            return System.currentTimeMillis();
        }
    }

    static interface Time {
        public long getCurrentTimeInMillis();
    }
}

