/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import io.vavr.control.Either;
import java.io.IOException;

class EitherDeserializer
extends ValueDeserializer<Either<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private JsonDeserializer<?> stringDeserializer;

    EitherDeserializer(JavaType valueType) {
        super(valueType, 2);
        this.javaType = valueType;
    }

    @Override
    public Either<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken nextToken = p.getCurrentToken();
        if (nextToken == JsonToken.START_ARRAY) {
            boolean right2 = false;
            Object value = null;
            int cnt = 0;
            JsonToken jsonToken = p.nextToken();
            while (jsonToken != JsonToken.END_ARRAY) {
                switch (++cnt) {
                    case 1: {
                        String def = (String)this.stringDeserializer.deserialize(p, ctxt);
                        if (EitherDeserializer.isRight(def)) {
                            right2 = true;
                            break;
                        }
                        if (EitherDeserializer.isLeft(def)) {
                            right2 = false;
                            break;
                        }
                        throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), jsonToken);
                    }
                    case 2: {
                        JsonDeserializer<?> deserializer = right2 ? this.deserializer(1) : this.deserializer(0);
                        value = (jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt));
                    }
                }
                jsonToken = p.nextToken();
            }
            if (cnt != 2) {
                throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), null);
            }
            return right2 ? Either.right(value) : Either.left(value);
        }
        if (nextToken == JsonToken.START_OBJECT) {
            JsonToken currentToken = p.getCurrentToken();
            String type2 = p.nextFieldName();
            if (EitherDeserializer.isRight(type2)) {
                JsonDeserializer<?> deserializer = this.deserializer(1);
                Object value = p.nextToken() != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
                return Either.right(value);
            }
            if (EitherDeserializer.isLeft(type2)) {
                JsonDeserializer<?> deserializer = this.deserializer(0);
                Object value = p.nextToken() != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
                return Either.left(value);
            }
            throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), currentToken);
        }
        throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), p.getCurrentToken());
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        this.stringDeserializer = ctxt.findContextualValueDeserializer(ctxt.constructType(String.class), null);
    }

    private static boolean isRight(String fieldName) {
        return "right".equals(fieldName) || "r".equals(fieldName);
    }

    private static boolean isLeft(String fieldName) {
        return "left".equals(fieldName) || "l".equals(fieldName);
    }
}

