/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StageSchedulingInfo {
    private final int numberOfInstances;
    private final MachineDefinition machineDefinition;
    private final List<JobConstraints> hardConstraints;
    private final List<JobConstraints> softConstraints;
    private final StageScalingPolicy scalingPolicy;
    private final boolean scalable;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public StageSchedulingInfo(@JsonProperty(value="numberOfInstances") int numberOfInstances, @JsonProperty(value="machineDefinition") MachineDefinition machineDefinition, @JsonProperty(value="hardConstraints") List<JobConstraints> hardConstraints, @JsonProperty(value="softConstraints") List<JobConstraints> softConstraints, @JsonProperty(value="scalingPolicy") StageScalingPolicy scalingPolicy, @JsonProperty(value="scalable") boolean scalable) {
        this.numberOfInstances = numberOfInstances;
        this.machineDefinition = machineDefinition;
        this.hardConstraints = hardConstraints;
        this.softConstraints = softConstraints;
        this.scalingPolicy = scalingPolicy;
        this.scalable = scalable;
    }

    public static void main(String[] args) {
        String json2 = "{\"numberOfInstances\":1,\"machineDefinition\":{\"cpuCores\":1.0,\"memoryMB\":2048.0,\"diskMB\":1.0,\"numPorts\":1},\"hardConstraints\":[\"UniqueHost\"],\"softConstraints\":[\"ExclusiveHost\"],\"scalable\":\"true\"}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            StageSchedulingInfo stageSchedulingInfo = mapper.readValue(json2, StageSchedulingInfo.class);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public MachineDefinition getMachineDefinition() {
        return this.machineDefinition;
    }

    public List<JobConstraints> getHardConstraints() {
        return this.hardConstraints;
    }

    public List<JobConstraints> getSoftConstraints() {
        return this.softConstraints;
    }

    public StageScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    public boolean getScalable() {
        return this.scalable;
    }

    public String toString() {
        return "StageSchedulingInfo{numberOfInstances=" + this.numberOfInstances + ", machineDefinition=" + this.machineDefinition + ", hardConstraints=" + this.hardConstraints + ", softConstraints=" + this.softConstraints + ", scalingPolicy=" + this.scalingPolicy + ", scalable=" + this.scalable + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hardConstraints == null ? 0 : this.hardConstraints.hashCode());
        result = 31 * result + (this.machineDefinition == null ? 0 : this.machineDefinition.hashCode());
        result = 31 * result + this.numberOfInstances;
        result = 31 * result + (this.scalable ? 1231 : 1237);
        result = 31 * result + (this.scalingPolicy == null ? 0 : this.scalingPolicy.hashCode());
        result = 31 * result + (this.softConstraints == null ? 0 : this.softConstraints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StageSchedulingInfo other = (StageSchedulingInfo)obj;
        if (this.hardConstraints == null ? other.hardConstraints != null : !this.hardConstraints.equals(other.hardConstraints)) {
            return false;
        }
        if (this.machineDefinition == null ? other.machineDefinition != null : !this.machineDefinition.equals(other.machineDefinition)) {
            return false;
        }
        if (this.numberOfInstances != other.numberOfInstances) {
            return false;
        }
        if (this.scalable != other.scalable) {
            return false;
        }
        if (this.scalingPolicy == null ? other.scalingPolicy != null : !this.scalingPolicy.equals(other.scalingPolicy)) {
            return false;
        }
        return !(this.softConstraints == null ? other.softConstraints != null : !this.softConstraints.equals(other.softConstraints));
    }

    public static StageSchedulingInfoBuilder builder() {
        return new StageSchedulingInfoBuilder();
    }

    public StageSchedulingInfoBuilder toBuilder() {
        StageSchedulingInfoBuilder builder = new StageSchedulingInfoBuilder().numberOfInstances(this.numberOfInstances).machineDefinition(this.machineDefinition).scalingPolicy(this.scalingPolicy).scalable(this.scalable);
        if (this.hardConstraints != null) {
            builder.hardConstraints(this.hardConstraints);
        }
        if (this.softConstraints != null) {
            builder.softConstraints(this.softConstraints);
        }
        return builder;
    }

    public static class StageSchedulingInfoBuilder {
        private int numberOfInstances;
        private MachineDefinition machineDefinition;
        private ArrayList<JobConstraints> hardConstraints;
        private ArrayList<JobConstraints> softConstraints;
        private StageScalingPolicy scalingPolicy;
        private boolean scalable;

        StageSchedulingInfoBuilder() {
        }

        public StageSchedulingInfoBuilder numberOfInstances(int numberOfInstances) {
            this.numberOfInstances = numberOfInstances;
            return this;
        }

        public StageSchedulingInfoBuilder machineDefinition(MachineDefinition machineDefinition) {
            this.machineDefinition = machineDefinition;
            return this;
        }

        public StageSchedulingInfoBuilder hardConstraint(JobConstraints hardConstraint) {
            if (this.hardConstraints == null) {
                this.hardConstraints = new ArrayList();
            }
            this.hardConstraints.add(hardConstraint);
            return this;
        }

        public StageSchedulingInfoBuilder hardConstraints(Collection<? extends JobConstraints> hardConstraints) {
            if (hardConstraints != null) {
                if (this.hardConstraints == null) {
                    this.hardConstraints = new ArrayList();
                }
                this.hardConstraints.addAll(hardConstraints);
            }
            return this;
        }

        public StageSchedulingInfoBuilder clearHardConstraints() {
            if (this.hardConstraints != null) {
                this.hardConstraints.clear();
            }
            return this;
        }

        public StageSchedulingInfoBuilder softConstraint(JobConstraints softConstraint) {
            if (this.softConstraints == null) {
                this.softConstraints = new ArrayList();
            }
            this.softConstraints.add(softConstraint);
            return this;
        }

        public StageSchedulingInfoBuilder softConstraints(Collection<? extends JobConstraints> softConstraints) {
            if (softConstraints != null) {
                if (this.softConstraints == null) {
                    this.softConstraints = new ArrayList();
                }
                this.softConstraints.addAll(softConstraints);
            }
            return this;
        }

        public StageSchedulingInfoBuilder clearSoftConstraints() {
            if (this.softConstraints != null) {
                this.softConstraints.clear();
            }
            return this;
        }

        public StageSchedulingInfoBuilder scalingPolicy(StageScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            return this;
        }

        public StageSchedulingInfoBuilder scalable(boolean scalable) {
            this.scalable = scalable;
            return this;
        }

        public StageSchedulingInfo build() {
            List<JobConstraints> softConstraints;
            List<JobConstraints> hardConstraints;
            switch (this.hardConstraints == null ? 0 : this.hardConstraints.size()) {
                case 0: {
                    hardConstraints = Collections.emptyList();
                    break;
                }
                case 1: {
                    hardConstraints = Collections.singletonList(this.hardConstraints.get(0));
                    break;
                }
                default: {
                    hardConstraints = Collections.unmodifiableList(new ArrayList<JobConstraints>(this.hardConstraints));
                }
            }
            switch (this.softConstraints == null ? 0 : this.softConstraints.size()) {
                case 0: {
                    softConstraints = Collections.emptyList();
                    break;
                }
                case 1: {
                    softConstraints = Collections.singletonList(this.softConstraints.get(0));
                    break;
                }
                default: {
                    softConstraints = Collections.unmodifiableList(new ArrayList<JobConstraints>(this.softConstraints));
                }
            }
            return new StageSchedulingInfo(this.numberOfInstances, this.machineDefinition, hardConstraints, softConstraints, this.scalingPolicy, this.scalable);
        }

        public String toString() {
            return "StageSchedulingInfo.StageSchedulingInfoBuilder(numberOfInstances=" + this.numberOfInstances + ", machineDefinition=" + this.machineDefinition + ", hardConstraints=" + this.hardConstraints + ", softConstraints=" + this.softConstraints + ", scalingPolicy=" + this.scalingPolicy + ", scalable=" + this.scalable + ")";
        }
    }
}

