/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.clojure.lang;

import io.mantisrx.mql.shaded.clojure.lang.AFn;
import io.mantisrx.mql.shaded.clojure.lang.ArraySeq;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import io.mantisrx.mql.shaded.clojure.lang.RT;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class TransformerIterator
implements Iterator {
    private static final Buffer EMPTY = new Empty();
    private static final Object NONE = new Object();
    private final Iterator sourceIter;
    private final IFn xf;
    private final boolean multi;
    private volatile Buffer buffer = EMPTY;
    private volatile Object next = NONE;
    private volatile boolean completed = false;

    private TransformerIterator(IFn xform, Iterator sourceIter, boolean multi) {
        this.sourceIter = sourceIter;
        this.xf = (IFn)xform.invoke(new AFn(){

            @Override
            public Object invoke() {
                return null;
            }

            @Override
            public Object invoke(Object acc) {
                return acc;
            }

            @Override
            public Object invoke(Object acc, Object o) {
                TransformerIterator.this.buffer = TransformerIterator.this.buffer.add(o);
                return acc;
            }
        });
        this.multi = multi;
    }

    public static Iterator create(IFn xform, Iterator source2) {
        return new TransformerIterator(xform, source2, false);
    }

    public static Iterator createMulti(IFn xform, List sources) {
        Iterator[] iters = new Iterator[sources.size()];
        for (int i = 0; i < sources.size(); ++i) {
            iters[i] = (Iterator)sources.get(i);
        }
        return new TransformerIterator(xform, new MultiIterator(iters), true);
    }

    private boolean step() {
        if (this.next != NONE) {
            return true;
        }
        while (this.next == NONE) {
            if (this.buffer.isEmpty()) {
                if (this.completed) {
                    return false;
                }
                if (this.sourceIter.hasNext()) {
                    Object iter = null;
                    iter = this.multi ? this.xf.applyTo(RT.cons(null, this.sourceIter.next())) : this.xf.invoke(null, this.sourceIter.next());
                    if (!RT.isReduced(iter)) continue;
                    this.xf.invoke(null);
                    this.completed = true;
                    continue;
                }
                this.xf.invoke(null);
                this.completed = true;
                continue;
            }
            this.next = this.buffer.remove();
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.step();
    }

    public Object next() {
        if (this.hasNext()) {
            Object ret = this.next;
            this.next = NONE;
            return ret;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class MultiIterator
    implements Iterator {
        private final Iterator[] iters;

        public MultiIterator(Iterator[] iters) {
            this.iters = iters;
        }

        @Override
        public boolean hasNext() {
            for (Iterator iter : this.iters) {
                if (iter.hasNext()) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            Object[] nexts = new Object[this.iters.length];
            for (int i = 0; i < this.iters.length; ++i) {
                nexts[i] = this.iters[i].next();
            }
            return new ArraySeq(nexts, 0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Many
    implements Buffer {
        private final Queue vals = new LinkedList();

        public Many(Object o1, Object o2) {
            this.vals.add(o1);
            this.vals.add(o2);
        }

        @Override
        public Buffer add(Object o) {
            this.vals.add(o);
            return this;
        }

        @Override
        public Object remove() {
            return this.vals.remove();
        }

        @Override
        public boolean isEmpty() {
            return this.vals.isEmpty();
        }

        public String toString() {
            return "Many: " + this.vals.toString();
        }
    }

    private static class Single
    implements Buffer {
        private volatile Object val;

        public Single(Object o) {
            this.val = o;
        }

        @Override
        public Buffer add(Object o) {
            if (this.val == NONE) {
                this.val = o;
                return this;
            }
            return new Many(this.val, o);
        }

        @Override
        public Object remove() {
            if (this.val == NONE) {
                throw new IllegalStateException("Removing object from empty buffer");
            }
            Object ret = this.val;
            this.val = NONE;
            return ret;
        }

        @Override
        public boolean isEmpty() {
            return this.val == NONE;
        }

        public String toString() {
            return "Single: " + this.val;
        }
    }

    private static class Empty
    implements Buffer {
        private Empty() {
        }

        @Override
        public Buffer add(Object o) {
            return new Single(o);
        }

        @Override
        public Object remove() {
            throw new IllegalStateException("Removing object from empty buffer");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "Empty";
        }
    }

    private static interface Buffer {
        public Buffer add(Object var1);

        public Object remove();

        public boolean isEmpty();
    }
}

