/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.websocket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.List;
import mantis.io.reactivex.netty.channel.ConnectionHandler;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketServerHandler;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketServerPipelineConfigurator;
import mantis.io.reactivex.netty.server.RxServer;
import rx.Observable;
import rx.subjects.PublishSubject;

public class WebSocketServer<I extends WebSocketFrame, O extends WebSocketFrame>
extends RxServer<I, O> {
    public WebSocketServer(ServerBootstrap bootstrap, int port, ConnectionHandler<I, O> connectionHandler) {
        this(bootstrap, port, null, new WrappedObservableConnectionHandler<I, O>(connectionHandler));
    }

    public WebSocketServer(ServerBootstrap bootstrap, int port, PipelineConfigurator<I, O> pipelineConfigurator, ConnectionHandler<I, O> connectionHandler) {
        this(bootstrap, port, pipelineConfigurator, new WrappedObservableConnectionHandler<I, O>(connectionHandler), null);
    }

    public WebSocketServer(ServerBootstrap bootstrap, int port, ConnectionHandler<I, O> connectionHandler, EventExecutorGroup connHandlingExecutor) {
        this(bootstrap, port, null, new WrappedObservableConnectionHandler<I, O>(connectionHandler), connHandlingExecutor);
    }

    public WebSocketServer(ServerBootstrap bootstrap, int port, PipelineConfigurator<I, O> pipelineConfigurator, ConnectionHandler<I, O> connectionHandler, EventExecutorGroup connHandlingExecutor) {
        super(bootstrap, port, pipelineConfigurator, new WrappedObservableConnectionHandler<I, O>(connectionHandler), connHandlingExecutor);
        List<PipelineConfigurator> constituentConfigurators = ((PipelineConfiguratorComposite)this.pipelineConfigurator).getConstituentConfigurators();
        boolean updatedSubject = false;
        for (PipelineConfigurator configurator : constituentConfigurators) {
            if (!(configurator instanceof WebSocketServerPipelineConfigurator)) continue;
            updatedSubject = true;
            WebSocketServerPipelineConfigurator requiredConfigurator = (WebSocketServerPipelineConfigurator)configurator;
            requiredConfigurator.useMetricEventsSubject(this.eventsSubject);
        }
        if (!updatedSubject) {
            throw new IllegalStateException("No server required configurator added.");
        }
    }

    static class WrappedObservableConnectionHandler<I, O>
    implements ConnectionHandler<I, O> {
        private final ConnectionHandler<I, O> originalHandler;

        WrappedObservableConnectionHandler(ConnectionHandler<I, O> originalHandler) {
            this.originalHandler = originalHandler;
        }

        @Override
        public Observable<Void> handle(final ObservableConnection<I, O> connection) {
            ChannelPipeline p = connection.getChannel().pipeline();
            ChannelHandlerContext hctx = p.context(WebSocketServerHandler.class);
            if (hctx != null) {
                WebSocketServerHandler handler = p.get(WebSocketServerHandler.class);
                final PublishSubject<Void> subject = PublishSubject.create();
                handler.addHandshakeFinishedListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future2) throws Exception {
                        WrappedObservableConnectionHandler.this.originalHandler.handle(connection).subscribe(subject);
                    }
                });
                return subject;
            }
            return this.originalHandler.handle(connection);
        }
    }
}

