/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.ServerPoller;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.RxClient;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class StaticServerPoller
implements ServerPoller {
    private final Set<RxClient.ServerInfo> servers;
    private final int periodSeconds;
    private final Scheduler scheduler;

    public StaticServerPoller(Set<RxClient.ServerInfo> servers, int periodSeconds, Scheduler scheduler) {
        this.servers = Collections.unmodifiableSet(servers);
        this.periodSeconds = periodSeconds;
        this.scheduler = scheduler;
    }

    public StaticServerPoller(Set<RxClient.ServerInfo> servers, int periodSeconds) {
        this(servers, periodSeconds, Schedulers.computation());
    }

    private Scheduler.Worker schedulePolling(final Subscriber<? super Set<RxClient.ServerInfo>> subscriber2) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        worker.schedulePeriodically(new Action0(){

            @Override
            public void call() {
                if (subscriber2.isUnsubscribed()) {
                    worker.unsubscribe();
                } else {
                    subscriber2.onNext(StaticServerPoller.this.servers);
                }
            }
        }, 0L, this.periodSeconds, TimeUnit.SECONDS);
        return worker;
    }

    @Override
    public Observable<Set<RxClient.ServerInfo>> servers() {
        return Observable.create(new Observable.OnSubscribe<Set<RxClient.ServerInfo>>(){

            @Override
            public void call(Subscriber<? super Set<RxClient.ServerInfo>> subscriber2) {
                StaticServerPoller.this.schedulePolling(subscriber2);
            }
        });
    }

    @Override
    public Set<RxClient.ServerInfo> getServers() {
        return this.servers;
    }
}

