/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.clojure.lang;

import io.mantisrx.mql.shaded.clojure.lang.ASeq;
import io.mantisrx.mql.shaded.clojure.lang.IDeref;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import io.mantisrx.mql.shaded.clojure.lang.IPending;
import io.mantisrx.mql.shaded.clojure.lang.IPersistentMap;
import io.mantisrx.mql.shaded.clojure.lang.IReduce;
import io.mantisrx.mql.shaded.clojure.lang.ISeq;
import io.mantisrx.mql.shaded.clojure.lang.RT;

public class Iterate
extends ASeq
implements IReduce,
IPending {
    private static final Object UNREALIZED_SEED = new Object();
    private final IFn f;
    private final Object prevSeed;
    private volatile Object _seed;
    private volatile ISeq _next;

    private Iterate(IFn f, Object prevSeed, Object seed) {
        this.f = f;
        this.prevSeed = prevSeed;
        this._seed = seed;
    }

    private Iterate(IPersistentMap meta, IFn f, Object prevSeed, Object seed, ISeq next2) {
        super(meta);
        this.f = f;
        this.prevSeed = prevSeed;
        this._seed = seed;
        this._next = next2;
    }

    public static ISeq create(IFn f, Object seed) {
        return new Iterate(f, null, seed);
    }

    @Override
    public boolean isRealized() {
        return this._seed != UNREALIZED_SEED;
    }

    @Override
    public Object first() {
        if (this._seed == UNREALIZED_SEED) {
            this._seed = this.f.invoke(this.prevSeed);
        }
        return this._seed;
    }

    @Override
    public ISeq next() {
        if (this._next == null) {
            this._next = new Iterate(this.f, this.first(), UNREALIZED_SEED);
        }
        return this._next;
    }

    @Override
    public Iterate withMeta(IPersistentMap meta) {
        return new Iterate(meta, this.f, this.prevSeed, this._seed, this._next);
    }

    @Override
    public Object reduce(IFn rf) {
        Object first2;
        Object ret = first2 = this.first();
        Object v = this.f.invoke(first2);
        while (!RT.isReduced(ret = rf.invoke(ret, v))) {
            v = this.f.invoke(v);
        }
        return ((IDeref)ret).deref();
    }

    @Override
    public Object reduce(IFn rf, Object start) {
        Object ret = start;
        Object v = this.first();
        while (!RT.isReduced(ret = rf.invoke(ret, v))) {
            v = this.f.invoke(v);
        }
        return ((IDeref)ret).deref();
    }
}

