/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.source.Index;
import io.mantisrx.runtime.source.Source;
import io.mantisrx.runtime.source.http.ClientResumePolicy;
import io.mantisrx.runtime.source.http.HttpClientFactory;
import io.mantisrx.runtime.source.http.HttpRequestFactory;
import io.mantisrx.runtime.source.http.HttpServerProvider;
import io.mantisrx.runtime.source.http.impl.HttpSourceImpl;
import io.mantisrx.runtime.source.http.impl.ServerContext;
import io.netty.buffer.ByteBuf;
import rx.Observable;
import rx.Observer;

public class ContextualHttpSource<E>
implements Source<ServerContext<E>> {
    private final HttpSourceImpl<ByteBuf, E, ServerContext<E>> impl;

    private ContextualHttpSource(HttpSourceImpl<ByteBuf, E, ServerContext<E>> impl) {
        this.impl = impl;
    }

    public static <E> Builder<E> builder(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory) {
        HttpSourceImpl.Builder builderImpl = HttpSourceImpl.builder(clientFactory, requestFactory, HttpSourceImpl.contextWrapper());
        return new Builder(builderImpl);
    }

    public static <E> Builder<E> builder(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory, ClientResumePolicy<ByteBuf, E> policy) {
        HttpSourceImpl.Builder builderImpl = HttpSourceImpl.builder(clientFactory, requestFactory, HttpSourceImpl.contextWrapper(), policy);
        return new Builder(builderImpl);
    }

    @Override
    public Observable<Observable<ServerContext<E>>> call(Context context, Index t2) {
        return this.impl.call(context, t2);
    }

    public static class Builder<E> {
        private final HttpSourceImpl.Builder<ByteBuf, E, ServerContext<E>> builderImpl;

        private Builder(HttpSourceImpl.Builder<ByteBuf, E, ServerContext<E>> builderImpl) {
            this.builderImpl = builderImpl;
        }

        public Builder<E> withServerProvider(HttpServerProvider serverProvider) {
            this.builderImpl.withServerProvider(serverProvider);
            return this;
        }

        public Builder<E> withActivityObserver(Observer<HttpSourceImpl.HttpSourceEvent> observer) {
            this.builderImpl.withActivityObserver(observer);
            return this;
        }

        public Builder<E> resumeWith(ClientResumePolicy<ByteBuf, E> policy) {
            this.builderImpl.resumeWith(policy);
            return this;
        }

        public ContextualHttpSource<E> build() {
            return new ContextualHttpSource(this.builderImpl.build());
        }
    }
}

