/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.internal.operators.NotificationLite;
import rx.subscriptions.Subscriptions;

final class SubjectSubscriptionManager<T>
extends AtomicReference<State<T>>
implements Observable.OnSubscribe<T> {
    private static final long serialVersionUID = 6035251036011671568L;
    volatile Object latest;
    boolean active = true;
    Action1<SubjectObserver<T>> onStart = Actions.empty();
    Action1<SubjectObserver<T>> onAdded = Actions.empty();
    Action1<SubjectObserver<T>> onTerminated = Actions.empty();

    public SubjectSubscriptionManager() {
        super(State.EMPTY);
    }

    @Override
    public void call(Subscriber<? super T> child) {
        SubjectObserver<? super T> bo = new SubjectObserver<T>(child);
        this.addUnsubscriber(child, bo);
        this.onStart.call(bo);
        if (!child.isUnsubscribed() && this.add(bo) && child.isUnsubscribed()) {
            this.remove(bo);
        }
    }

    void addUnsubscriber(Subscriber<? super T> child, final SubjectObserver<T> bo) {
        child.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                SubjectSubscriptionManager.this.remove(bo);
            }
        }));
    }

    void setLatest(Object value) {
        this.latest = value;
    }

    Object getLatest() {
        return this.latest;
    }

    SubjectObserver<T>[] observers() {
        return ((State)this.get()).observers;
    }

    boolean add(SubjectObserver<T> o) {
        State newState;
        State oldState;
        do {
            oldState = (State)this.get();
            if (!oldState.terminated) continue;
            this.onTerminated.call(o);
            return false;
        } while (!this.compareAndSet(oldState, newState = oldState.add(o)));
        this.onAdded.call(o);
        return true;
    }

    void remove(SubjectObserver<T> o) {
        State oldState;
        State newState;
        do {
            oldState = (State)this.get();
            if (!oldState.terminated) continue;
            return;
        } while ((newState = oldState.remove(o)) != oldState && !this.compareAndSet(oldState, newState));
    }

    SubjectObserver<T>[] next(Object n) {
        this.setLatest(n);
        return ((State)this.get()).observers;
    }

    SubjectObserver<T>[] terminate(Object n) {
        this.setLatest(n);
        this.active = false;
        State oldState = (State)this.get();
        if (oldState.terminated) {
            return State.NO_OBSERVERS;
        }
        return this.getAndSet(State.TERMINATED).observers;
    }

    protected static final class SubjectObserver<T>
    implements Observer<T> {
        final Subscriber<? super T> actual;
        boolean first = true;
        boolean emitting;
        List<Object> queue;
        boolean fastPath;
        volatile boolean caughtUp;
        private volatile Object index;

        public SubjectObserver(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable e2) {
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object n) {
            if (!this.fastPath) {
                SubjectObserver subjectObserver = this;
                synchronized (subjectObserver) {
                    this.first = false;
                    if (this.emitting) {
                        if (this.queue == null) {
                            this.queue = new ArrayList<Object>();
                        }
                        this.queue.add(n);
                        return;
                    }
                }
                this.fastPath = true;
            }
            NotificationLite.accept(this.actual, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst(Object n) {
            SubjectObserver subjectObserver = this;
            synchronized (subjectObserver) {
                if (!this.first || this.emitting) {
                    return;
                }
                this.first = false;
                this.emitting = n != null;
            }
            if (n != null) {
                this.emitLoop(null, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void emitLoop(List<Object> localQueue, Object current) {
            Object object;
            boolean once = true;
            boolean skipFinal = false;
            try {
                while (true) {
                    if (localQueue != null) {
                        for (Object e2 : localQueue) {
                            this.accept(e2);
                        }
                    }
                    if (once) {
                        once = false;
                        this.accept(current);
                    }
                    object = this;
                    synchronized (object) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                }
            }
            finally {
                if (!skipFinal) {
                    object = this;
                    synchronized (object) {
                        this.emitting = false;
                    }
                }
            }
        }

        void accept(Object n) {
            if (n != null) {
                NotificationLite.accept(this.actual, n);
            }
        }

        Observer<? super T> getActual() {
            return this.actual;
        }

        public <I> I index() {
            return (I)this.index;
        }

        public void index(Object newIndex) {
            this.index = newIndex;
        }
    }

    protected static final class State<T> {
        final boolean terminated;
        final SubjectObserver[] observers;
        static final SubjectObserver[] NO_OBSERVERS = new SubjectObserver[0];
        static final State TERMINATED = new State(true, NO_OBSERVERS);
        static final State EMPTY = new State(false, NO_OBSERVERS);

        public State(boolean terminated, SubjectObserver[] observers) {
            this.terminated = terminated;
            this.observers = observers;
        }

        public State add(SubjectObserver o) {
            SubjectObserver[] a = this.observers;
            int n = a.length;
            SubjectObserver[] b = new SubjectObserver[n + 1];
            System.arraycopy(this.observers, 0, b, 0, n);
            b[n] = o;
            return new State<T>(this.terminated, b);
        }

        public State remove(SubjectObserver o) {
            SubjectObserver[] a = this.observers;
            int n = a.length;
            if (n == 1 && a[0] == o) {
                return EMPTY;
            }
            if (n == 0) {
                return this;
            }
            SubjectObserver[] b = new SubjectObserver[n - 1];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                SubjectObserver ai = a[i];
                if (ai == o) continue;
                if (j == n - 1) {
                    return this;
                }
                b[j++] = ai;
            }
            if (j == 0) {
                return EMPTY;
            }
            if (j < n - 1) {
                SubjectObserver[] c = new SubjectObserver[j];
                System.arraycopy(b, 0, c, 0, j);
                b = c;
            }
            return new State<T>(this.terminated, b);
        }
    }
}

