/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.util;

import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;

public class MultipleFutureListener
implements ChannelFutureListener {
    private final ChannelPromise completionPromise;
    private final Observable<Void> completionObservable;
    private final AtomicInteger listeningToCount = new AtomicInteger();
    private final ConcurrentLinkedQueue<ChannelFuture> pendingFutures = new ConcurrentLinkedQueue();

    public MultipleFutureListener(ChannelPromise completionPromise) {
        if (null == completionPromise) {
            throw new NullPointerException("Promise can not be null.");
        }
        this.completionPromise = completionPromise;
        this.completionObservable = Observable.create(new Observable.OnSubscribe<Void>(){

            @Override
            public void call(final Subscriber<? super Void> subscriber2) {
                if (MultipleFutureListener.this.listeningToCount.get() == 0) {
                    MultipleFutureListener.this.completionPromise.trySuccess();
                }
                MultipleFutureListener.this.completionPromise.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future2) throws Exception {
                        if (future2.isSuccess()) {
                            subscriber2.onCompleted();
                        } else {
                            subscriber2.onError(future2.cause());
                        }
                    }
                });
            }
        });
    }

    public void listen(ChannelFuture future2) {
        this.pendingFutures.add(future2);
        this.listeningToCount.incrementAndGet();
        future2.addListener(this);
    }

    public Observable<Void> asObservable() {
        return this.completionObservable;
    }

    public void cancelPendingFutures(boolean mayInterruptIfRunning) {
        Iterator<ChannelFuture> iterator = this.pendingFutures.iterator();
        while (iterator.hasNext()) {
            ChannelFuture pendingFuture = iterator.next();
            iterator.remove();
            pendingFuture.cancel(mayInterruptIfRunning);
        }
    }

    @Override
    public void operationComplete(ChannelFuture future2) throws Exception {
        this.pendingFutures.remove(future2);
        int nowListeningTo = this.listeningToCount.decrementAndGet();
        if (!future2.isSuccess()) {
            this.completionPromise.tryFailure(future2.cause());
        } else if (nowListeningTo == 0) {
            this.completionPromise.trySuccess(null);
        }
    }
}

