/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.text.sse;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import mantis.io.reactivex.netty.protocol.text.sse.ServerSentEvent;

@Deprecated
public class ServerSentEventDecoder
extends ReplayingDecoder<State> {
    private final MessageBuffer eventBuffer = new MessageBuffer();
    private boolean eventStarted;

    public ServerSentEventDecoder() {
        super(State.NEW_LINE);
    }

    private static boolean isLineDelimiter(char c) {
        return c == '\r' || c == '\n';
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case NEW_LINE: {
                String line = this.readFullLine(in);
                int colonIndex = line.indexOf(58);
                if (colonIndex <= 0) break;
                String type2 = line.substring(0, colonIndex).trim();
                if ("data".equals(type2)) {
                    this.eventStarted = true;
                    this.eventBuffer.appendEventData(line.substring(colonIndex + 1).trim());
                }
                if ("event".equals(type2)) {
                    this.eventBuffer.setEventType(line.substring(colonIndex + 1).trim());
                }
                if (!"id".equals(type2)) break;
                this.eventBuffer.setEventId(line.substring(colonIndex + 1).trim());
                break;
            }
            case END_OF_LINE: {
                int skipped = this.skipLineDelimiters(in);
                if (skipped <= 0 || !this.eventStarted) break;
                out.add(this.eventBuffer.toMessage());
                this.eventBuffer.reset();
                this.eventStarted = false;
            }
        }
    }

    private String readFullLine(ByteBuf in) {
        StringBuilder line = new StringBuilder();
        while (true) {
            char c;
            if (ServerSentEventDecoder.isLineDelimiter(c = (char)in.readByte())) break;
            line.append(c);
        }
        line.append("");
        this.checkpoint(State.END_OF_LINE);
        return line.toString();
    }

    private int skipLineDelimiters(ByteBuf in) {
        int skipped = 0;
        while (in.writerIndex() - in.readerIndex() > 0) {
            char c = (char)in.readByte();
            if (ServerSentEventDecoder.isLineDelimiter(c)) {
                ++skipped;
                continue;
            }
            in.readerIndex(in.readerIndex() - 1);
            this.checkpoint(State.NEW_LINE);
            break;
        }
        return skipped;
    }

    public static enum State {
        NEW_LINE,
        END_OF_LINE;

    }

    private static class MessageBuffer {
        private boolean eventTypePresent;
        private final StringBuilder eventType = new StringBuilder();
        private final StringBuilder eventData = new StringBuilder();
        private boolean eventIdPresent;
        private final StringBuilder eventId = new StringBuilder();

        private MessageBuffer() {
            this.reset();
        }

        public MessageBuffer setEventType(String eventType) {
            this.eventType.setLength(0);
            this.eventType.append(eventType);
            this.eventTypePresent = true;
            return this;
        }

        public MessageBuffer appendEventData(String eventData) {
            if (this.eventData.length() > 0) {
                this.eventData.append('\n');
            }
            this.eventData.append(eventData);
            return this;
        }

        public MessageBuffer setEventId(String id) {
            this.eventId.setLength(0);
            this.eventId.append(id);
            this.eventIdPresent = true;
            return this;
        }

        public ServerSentEvent toMessage() {
            ServerSentEvent message = new ServerSentEvent(this.eventIdPresent ? this.eventId.toString() : null, this.eventTypePresent ? this.eventType.toString() : null, this.eventData.toString());
            this.reset();
            return message;
        }

        public void reset() {
            this.eventIdPresent = false;
            this.eventId.setLength(0);
            this.eventTypePresent = false;
            this.eventType.setLength(0);
            this.eventData.setLength(0);
        }
    }
}

