/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.websocket;

import io.mantisrx.shaded.io.netty.bootstrap.ServerBootstrap;
import io.mantisrx.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import mantis.io.reactivex.netty.channel.ConnectionHandler;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketServer;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketServerPipelineConfigurator;
import mantis.io.reactivex.netty.server.ConnectionBasedServerBuilder;
import mantis.io.reactivex.netty.server.RxServer;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public class WebSocketServerBuilder<I extends WebSocketFrame, O extends WebSocketFrame>
extends ConnectionBasedServerBuilder<I, O, WebSocketServerBuilder<I, O>> {
    private String webSocketURI;
    private String subprotocols;
    private boolean allowExtensions;
    private int maxFramePayloadLength = 65536;
    private boolean messageAggregator;

    public WebSocketServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        super(port, connectionHandler);
    }

    @Override
    public WebSocketServer<I, O> build() {
        return (WebSocketServer)super.build();
    }

    @Override
    protected RxServer<I, O> createServer() {
        WebSocketServerPipelineConfigurator webSocketPipeline = new WebSocketServerPipelineConfigurator(this.webSocketURI, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength, this.messageAggregator);
        if (this.getPipelineConfigurator() != null) {
            this.appendPipelineConfigurator(webSocketPipeline);
        } else {
            this.pipelineConfigurator(webSocketPipeline);
        }
        return new WebSocketServer((ServerBootstrap)this.serverBootstrap, this.port, this.pipelineConfigurator, this.connectionHandler, this.eventExecutorGroup);
    }

    public WebSocketServerBuilder<I, O> withWebSocketURI(String uri) {
        this.webSocketURI = uri;
        return this;
    }

    public WebSocketServerBuilder<I, O> withSubprotocol(String subprotocols) {
        this.subprotocols = subprotocols;
        return this;
    }

    public WebSocketServerBuilder<I, O> withAllowExtensions(boolean allowExtensions) {
        this.allowExtensions = allowExtensions;
        return this;
    }

    public WebSocketServerBuilder<I, O> withMaxFramePayloadLength(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
        return this;
    }

    public WebSocketServerBuilder<I, O> withMessageAggregator(boolean messageAggregator) {
        this.messageAggregator = messageAggregator;
        return this;
    }

    @Override
    protected MetricEventsListener<? extends ServerMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, RxServer<I, O> server2) {
        return factory.forWebSocketServer((WebSocketServer)server2);
    }
}

