/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.sse;

import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.mantisrx.shaded.io.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerPipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEventEncoder;

public class SseServerPipelineConfigurator<I>
implements PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<ServerSentEvent>> {
    public static final String SSE_ENCODER_HANDLER_NAME = "sse-encoder";
    public static final ServerSentEventEncoder SERVER_SENT_EVENT_ENCODER = new ServerSentEventEncoder();
    public static final String SSE_RESPONSE_HEADERS_COMPLETER = "sse-response-headers-completer";
    private final HttpServerPipelineConfigurator<I, ?> serverPipelineConfigurator;

    public SseServerPipelineConfigurator() {
        this(new HttpServerPipelineConfigurator());
    }

    public SseServerPipelineConfigurator(HttpServerPipelineConfigurator<I, ?> serverPipelineConfigurator) {
        this.serverPipelineConfigurator = serverPipelineConfigurator;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        this.serverPipelineConfigurator.configureNewPipeline(pipeline);
        pipeline.addLast(SSE_ENCODER_HANDLER_NAME, (ChannelHandler)SERVER_SENT_EVENT_ENCODER);
        pipeline.addLast(SSE_RESPONSE_HEADERS_COMPLETER, (ChannelHandler)new ChannelOutboundHandlerAdapter(){

            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
                HttpServerResponse rxResponse;
                String contentTypeHeader;
                if (HttpServerResponse.class.isAssignableFrom(msg.getClass()) && null == (contentTypeHeader = (rxResponse = (HttpServerResponse)msg).getHeaders().get("Content-Type"))) {
                    rxResponse.getHeaders().set("Content-Type", (Object)"text/event-stream");
                }
                super.write(ctx, msg, promise2);
            }
        });
    }
}

