/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server;

import io.mantisrx.shaded.io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;

public class UriInfoHolder {
    private final String uri;
    private final String queryString;
    private final QueryStringDecoder decoder;

    public UriInfoHolder(String uri) {
        this.uri = uri;
        int indexOfStartOfQP = uri.indexOf(63);
        this.queryString = -1 != indexOfStartOfQP && uri.length() >= indexOfStartOfQP ? uri.substring(indexOfStartOfQP + 1) : "";
        this.decoder = new QueryStringDecoder(this.getPath(uri));
    }

    private String getPath(String uri) {
        int offset = 0;
        if (uri.startsWith("http://")) {
            offset = "http://".length();
        } else if (uri.startsWith("https://")) {
            offset = "https://".length();
        }
        if (offset == 0) {
            return uri;
        }
        int firstSlash = uri.indexOf("/", offset);
        return firstSlash != -1 ? uri.substring(firstSlash) : uri;
    }

    public String getRawUriString() {
        return this.uri;
    }

    public synchronized String getPath() {
        return this.decoder.path();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public synchronized Map<String, List<String>> getQueryParameters() {
        return this.decoder.parameters();
    }
}

