/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.mantisrx.shaded.io.netty.handler.codec.http.HttpMessage;
import io.mantisrx.shaded.io.netty.handler.codec.http.HttpRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpRequestHeaders {
    private final HttpRequest nettyRequest;
    private final HttpHeaders nettyHeaders;

    HttpRequestHeaders(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
        this.nettyHeaders = this.nettyRequest.headers();
    }

    public boolean contains(CharSequence name2) {
        return this.nettyHeaders.contains(name2);
    }

    public boolean contains(CharSequence name2, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name2, value, ignoreCaseValue);
    }

    public boolean contains(String name2) {
        return this.nettyHeaders.contains(name2);
    }

    public boolean contains(String name2, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name2, value, ignoreCaseValue);
    }

    public void encodeAscii(CharSequence seq, ByteBuf buf) {
        HttpHeaders.encodeAscii(seq, buf);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    public boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        return HttpHeaders.equalsIgnoreCase(name1, name2);
    }

    public String get(CharSequence name2) {
        return this.nettyHeaders.get(name2);
    }

    public String get(String name2) {
        return this.nettyHeaders.get(name2);
    }

    public List<String> getAll(CharSequence name2) {
        return this.nettyHeaders.getAll(name2);
    }

    public List<String> getAll(String name2) {
        return this.nettyHeaders.getAll(name2);
    }

    public long getContentLength() {
        return HttpHeaders.getContentLength(this.nettyRequest);
    }

    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength(this.nettyRequest, defaultValue);
    }

    public Date getDate() throws ParseException {
        return HttpHeaders.getDate(this.nettyRequest);
    }

    public Date getDate(Date defaultValue) {
        return HttpHeaders.getDate(this.nettyRequest, defaultValue);
    }

    public Date getDateHeader(CharSequence name2) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name2);
    }

    public Date getDateHeader(CharSequence name2, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name2, defaultValue);
    }

    public Date getDateHeader(String name2) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name2);
    }

    public Date getDateHeader(String name2, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name2, defaultValue);
    }

    public String getHeader(CharSequence name2) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name2);
    }

    public String getHeader(CharSequence name2, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name2, defaultValue);
    }

    public String getHeader(String name2) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name2);
    }

    public String getHeader(String name2, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name2, defaultValue);
    }

    public String getHost() {
        return HttpHeaders.getHost(this.nettyRequest);
    }

    public String getHost(String defaultValue) {
        return HttpHeaders.getHost(this.nettyRequest, defaultValue);
    }

    public int getIntHeader(CharSequence name2) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name2);
    }

    public int getIntHeader(CharSequence name2, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name2, defaultValue);
    }

    public int getIntHeader(String name2) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name2);
    }

    public int getIntHeader(String name2, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name2, defaultValue);
    }

    public boolean is100ContinueExpected() {
        return HttpHeaders.is100ContinueExpected(this.nettyRequest);
    }

    public boolean isContentLengthSet() {
        return HttpHeaders.isContentLengthSet(this.nettyRequest);
    }

    public boolean hasContent() {
        if (this.isContentLengthSet()) {
            return this.getContentLength() > 0L;
        }
        return this.isTransferEncodingChunked();
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive(this.nettyRequest);
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaders.isTransferEncodingChunked(this.nettyRequest);
    }

    public Set<String> names() {
        return this.nettyHeaders.names();
    }
}

