/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.client;

import io.mantisrx.shaded.io.netty.bootstrap.Bootstrap;
import java.util.concurrent.ConcurrentHashMap;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.client.ClientChannelFactory;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.ConnectionPoolBuilder;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import mantis.io.reactivex.netty.protocol.http.client.HttpClient;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientImpl;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import rx.Observable;
import rx.Subscription;

public class CompositeHttpClient<I, O>
extends HttpClientImpl<I, O> {
    private final ConcurrentHashMap<RxClient.ServerInfo, HttpClient<I, O>> httpClients = new ConcurrentHashMap();
    private final PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator;
    private final ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder;

    public CompositeHttpClient(String name2, RxClient.ServerInfo defaultServer, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>> channelFactory, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name2, defaultServer, clientBootstrap, pipelineConfigurator, clientConfig, channelFactory, connectionFactory, eventsSubject);
        this.pipelineConfigurator = pipelineConfigurator;
        this.poolBuilder = null;
        this.httpClients.put(defaultServer, this);
    }

    CompositeHttpClient(String name2, RxClient.ServerInfo defaultServer, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name2, defaultServer, clientBootstrap, pipelineConfigurator, clientConfig, poolBuilder, eventsSubject);
        this.pipelineConfigurator = pipelineConfigurator;
        this.poolBuilder = poolBuilder;
        this.httpClients.put(defaultServer, this);
    }

    public Observable<HttpClientResponse<O>> submit(RxClient.ServerInfo serverInfo, HttpClientRequest<I> request) {
        HttpClient<I, O> client = this.getClient(serverInfo);
        return client.submit(request);
    }

    public Observable<HttpClientResponse<O>> submit(RxClient.ServerInfo serverInfo, HttpClientRequest<I> request, HttpClient.HttpClientConfig config) {
        HttpClient<I, O> client = this.getClient(serverInfo);
        return client.submit(request, config);
    }

    private HttpClient<I, O> getClient(RxClient.ServerInfo serverInfo) {
        HttpClient<I, O> existing;
        HttpClient<I, O> client = this.httpClients.get(serverInfo);
        if (null == client && null != (existing = this.httpClients.putIfAbsent(serverInfo, client = this.newClient(serverInfo)))) {
            client.shutdown();
            client = existing;
        }
        return client;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (HttpClient<I, O> client : this.httpClients.values()) {
            if (client == this) continue;
            client.shutdown();
        }
    }

    public Subscription subscribe(RxClient.ServerInfo server2, MetricEventsListener<? extends ClientMetricsEvent<?>> listener) {
        HttpClient<I, O> client = this.httpClients.get(server2);
        if (null == client) {
            throw new IllegalArgumentException("Invalid server: " + server2.getHost() + ':' + server2.getPort());
        }
        return client.subscribe(listener);
    }

    public RxClient.ServerInfo getDefaultServer() {
        return this.serverInfo;
    }

    private HttpClientImpl<I, O> newClient(RxClient.ServerInfo serverInfo) {
        if (null != this.poolBuilder) {
            return new HttpClientImpl<I, O>(this.name, serverInfo, this.clientBootstrap.clone(), this.pipelineConfigurator, this.clientConfig, this.clonePoolBuilder(serverInfo, this.poolBuilder), (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
        }
        return new HttpClientImpl<I, O>(this.name, serverInfo, this.clientBootstrap.clone(), this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.connectionFactory, (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
    }

    private ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> clonePoolBuilder(RxClient.ServerInfo serverInfo, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder) {
        ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> toReturn = poolBuilder.copy(serverInfo);
        toReturn.withConnectionPoolLimitStrategy(((CompositeHttpClientBuilder.CloneablePoolLimitDeterminationStrategy)poolBuilder.getLimitDeterminationStrategy()).copy());
        return toReturn;
    }
}

