/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http;

import io.mantisrx.shaded.io.netty.handler.codec.http.Cookie;
import io.mantisrx.shaded.io.netty.handler.codec.http.CookieDecoder;
import io.mantisrx.shaded.io.netty.handler.codec.http.HttpHeaders;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CookiesHolder {
    private final HttpHeaders nettyHeaders;
    private final String cookiesHeaderName;
    private Map<String, Set<Cookie>> allCookies;
    private boolean cookiesParsed;

    private CookiesHolder(HttpHeaders nettyHeaders, String cookiesHeaderName) {
        this.nettyHeaders = nettyHeaders;
        this.cookiesHeaderName = cookiesHeaderName;
        this.allCookies = Collections.emptyMap();
    }

    public Map<String, Set<Cookie>> getAllCookies() {
        return this._parseIfNeededAndGet();
    }

    public static CookiesHolder newClientResponseHolder(HttpHeaders headers) {
        return new CookiesHolder(headers, "Set-Cookie");
    }

    public static CookiesHolder newServerRequestHolder(HttpHeaders headers) {
        return new CookiesHolder(headers, "Cookie");
    }

    private synchronized Map<String, Set<Cookie>> _parseIfNeededAndGet() {
        if (this.cookiesParsed) {
            return this.allCookies;
        }
        List<String> allCookieHeaders = this.nettyHeaders.getAll(this.cookiesHeaderName);
        HashMap<String, HashSet<Cookie>> cookies = new HashMap<String, HashSet<Cookie>>();
        for (String aCookieHeader : allCookieHeaders) {
            Set<Cookie> decode = CookieDecoder.decode(aCookieHeader);
            for (Cookie cookie : decode) {
                HashSet<Cookie> existingCookiesOfName = (HashSet<Cookie>)cookies.get(cookie.getName());
                if (null == existingCookiesOfName) {
                    existingCookiesOfName = new HashSet<Cookie>();
                    cookies.put(cookie.getName(), existingCookiesOfName);
                }
                existingCookiesOfName.add(cookie);
            }
        }
        this.allCookies = Collections.unmodifiableMap(cookies);
        this.cookiesParsed = true;
        return this.allCookies;
    }
}

