/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.pipeline.ssl;

import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.io.netty.handler.ssl.SslHandler;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import mantis.io.reactivex.netty.pipeline.ssl.SslCompletionHandler;

public class SslPipelineConfigurator<I, O>
implements PipelineConfigurator<I, O> {
    public static final String SSL_HANDLER_NAME = "ssl-handler";
    public static final String SSL_COMPLETION_HANDLER_NAME = "ssl-completion-handler";
    private final SSLEngineFactory sslEngineFactory;

    public SslPipelineConfigurator(SSLEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        SslHandler sslHandler = new SslHandler(this.sslEngineFactory.createSSLEngine(pipeline.channel().alloc()));
        pipeline.addFirst(SSL_HANDLER_NAME, (ChannelHandler)sslHandler);
        pipeline.addAfter(SSL_HANDLER_NAME, SSL_COMPLETION_HANDLER_NAME, new SslCompletionHandler(sslHandler.handshakeFuture()));
    }
}

