/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.pipeline.ssl;

import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.handler.ssl.SslContext;
import io.mantisrx.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.mantisrx.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import mantis.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;

public final class DefaultFactories {
    private static SSLEngineFactory SELF_SIGNED;
    private static SSLEngineFactory TRUST_ALL;

    private DefaultFactories() {
    }

    public static SSLEngineFactory fromSSLContext(SSLContext sslContext) {
        return new SSLContextBasedFactory(sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLEngineFactory selfSigned() {
        if (SELF_SIGNED != null) return SELF_SIGNED;
        Class<SelfSignedSSLEngineFactory> clazz = SelfSignedSSLEngineFactory.class;
        synchronized (SelfSignedSSLEngineFactory.class) {
            SELF_SIGNED = new SelfSignedSSLEngineFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SELF_SIGNED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLEngineFactory trustAll() {
        if (TRUST_ALL != null) return TRUST_ALL;
        Class<TrustAllSSLEngineFactory> clazz = TrustAllSSLEngineFactory.class;
        synchronized (TrustAllSSLEngineFactory.class) {
            TRUST_ALL = new TrustAllSSLEngineFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return TRUST_ALL;
        }
    }

    private static class SelfSignedSSLEngineFactory
    implements SSLEngineFactory {
        private final SslContext sslCtx;

        private SelfSignedSSLEngineFactory() {
            SelfSignedCertificate ssc;
            try {
                ssc = new SelfSignedCertificate();
            }
            catch (CertificateException e2) {
                throw new IllegalStateException("Self signed certificate creation error", e2);
            }
            try {
                this.sslCtx = SslContext.newServerContext(ssc.certificate(), ssc.privateKey());
            }
            catch (SSLException e3) {
                throw new IllegalStateException("Failed to create Netty's Ssl context with self signed certificate", e3);
            }
        }

        @Override
        public SSLEngine createSSLEngine(ByteBufAllocator allocator) {
            return this.sslCtx.newEngine(allocator);
        }
    }

    private static class TrustAllSSLEngineFactory
    implements SSLEngineFactory {
        private final SslContext sslCtx;

        private TrustAllSSLEngineFactory() {
            try {
                this.sslCtx = SslContext.newClientContext(InsecureTrustManagerFactory.INSTANCE);
            }
            catch (SSLException e2) {
                throw new IllegalStateException("Failed to create Netty's Ssl context with InsecureTrustManagerFactory", e2);
            }
        }

        @Override
        public SSLEngine createSSLEngine(ByteBufAllocator allocator) {
            return this.sslCtx.newEngine(allocator);
        }
    }

    public static class SSLContextBasedFactory
    implements SSLEngineFactory {
        private final SSLContext sslContext;

        public SSLContextBasedFactory(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        @Override
        public SSLEngine createSSLEngine(ByteBufAllocator allocator) {
            return this.sslContext.createSSLEngine();
        }
    }
}

