/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.client;

import io.mantisrx.shaded.io.netty.bootstrap.Bootstrap;
import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.ChannelInitializer;
import java.util.concurrent.atomic.AtomicBoolean;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.client.ClientChannelFactory;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.ConnectionPool;
import mantis.io.reactivex.netty.client.ConnectionPoolBuilder;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

public class RxClientImpl<I, O>
implements RxClient<I, O> {
    protected final String name;
    protected final RxClient.ServerInfo serverInfo;
    protected final Bootstrap clientBootstrap;
    protected final PipelineConfigurator<O, I> pipelineConfigurator;
    protected final ClientChannelFactory<O, I> channelFactory;
    protected final ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory;
    protected final RxClient.ClientConfig clientConfig;
    protected final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    protected final ConnectionPool<O, I> pool;
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public RxClientImpl(String name2, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<O, I> pipelineConfigurator, RxClient.ClientConfig clientConfig, ClientChannelFactory<O, I> channelFactory, ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        if (null == name2) {
            throw new NullPointerException("Name can not be null.");
        }
        if (null == clientBootstrap) {
            throw new NullPointerException("Client bootstrap can not be null.");
        }
        if (null == serverInfo) {
            throw new NullPointerException("Server info can not be null.");
        }
        if (null == clientConfig) {
            throw new NullPointerException("Client config can not be null.");
        }
        if (null == connectionFactory) {
            throw new NullPointerException("Connection factory can not be null.");
        }
        if (null == channelFactory) {
            throw new NullPointerException("Channel factory can not be null.");
        }
        this.name = name2;
        this.pool = null;
        this.eventsSubject = eventsSubject;
        this.clientConfig = clientConfig;
        this.serverInfo = serverInfo;
        this.clientBootstrap = clientBootstrap;
        this.connectionFactory = connectionFactory;
        this.connectionFactory.useMetricEventsSubject(eventsSubject);
        this.channelFactory = channelFactory;
        this.channelFactory.useMetricEventsSubject(eventsSubject);
        this.pipelineConfigurator = pipelineConfigurator;
        final PipelineConfigurator<O, I> configurator = this.adaptPipelineConfigurator(pipelineConfigurator, clientConfig, eventsSubject);
        this.clientBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel ch) throws Exception {
                configurator.configureNewPipeline(ch.pipeline());
            }
        });
    }

    public RxClientImpl(String name2, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<O, I> pipelineConfigurator, RxClient.ClientConfig clientConfig, ConnectionPoolBuilder<O, I> poolBuilder, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        if (null == name2) {
            throw new NullPointerException("Name can not be null.");
        }
        if (null == clientBootstrap) {
            throw new NullPointerException("Client bootstrap can not be null.");
        }
        if (null == serverInfo) {
            throw new NullPointerException("Server info can not be null.");
        }
        if (null == clientConfig) {
            throw new NullPointerException("Client config can not be null.");
        }
        if (null == poolBuilder) {
            throw new NullPointerException("Pool builder can not be null.");
        }
        this.name = name2;
        this.eventsSubject = eventsSubject;
        this.clientConfig = clientConfig;
        this.serverInfo = serverInfo;
        this.clientBootstrap = clientBootstrap;
        this.pipelineConfigurator = pipelineConfigurator;
        final PipelineConfigurator<O, I> configurator = this.adaptPipelineConfigurator(pipelineConfigurator, clientConfig, eventsSubject);
        this.clientBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel ch) throws Exception {
                configurator.configureNewPipeline(ch.pipeline());
            }
        });
        this.pool = poolBuilder.build();
        this.channelFactory = poolBuilder.getChannelFactory();
        this.connectionFactory = poolBuilder.getConnectionFactory();
    }

    @Override
    public Observable<ObservableConnection<O, I>> connect() {
        if (this.isShutdown.get()) {
            return Observable.error(new IllegalStateException("Client is already shutdown."));
        }
        Observable<ObservableConnection<Object, Object>> toReturn = null != this.pool ? this.pool.acquire() : Observable.create(new Observable.OnSubscribe<ObservableConnection<O, I>>(){

            @Override
            public void call(Subscriber<? super ObservableConnection<O, I>> subscriber2) {
                try {
                    RxClientImpl.this.channelFactory.connect(subscriber2, RxClientImpl.this.serverInfo, RxClientImpl.this.connectionFactory);
                }
                catch (Throwable throwable) {
                    subscriber2.onError(throwable);
                }
            }
        });
        return toReturn.take(1);
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            return;
        }
        if (null != this.pool) {
            this.pool.shutdown();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    protected PipelineConfigurator<O, I> adaptPipelineConfigurator(PipelineConfigurator<O, I> pipelineConfigurator, RxClient.ClientConfig clientConfig, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        return PipelineConfigurators.createClientConfigurator(pipelineConfigurator, clientConfig, eventsSubject);
    }

    @Override
    public Subscription subscribe(MetricEventsListener<? extends ClientMetricsEvent<?>> listener) {
        return this.eventsSubject.subscribe(listener);
    }
}

