/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.client;

import io.mantisrx.shaded.io.netty.channel.Channel;
import mantis.io.reactivex.netty.client.ClientChannelMetricEventProvider;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.PoolConfig;
import mantis.io.reactivex.netty.client.PooledConnection;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;

public class PooledConnectionFactory<I, O>
implements ClientConnectionFactory<I, O, PooledConnection<I, O>> {
    private final PoolConfig poolConfig;
    private MetricEventsSubject<?> eventsSubject;

    public PooledConnectionFactory(PoolConfig poolConfig, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.poolConfig = poolConfig;
        this.eventsSubject = eventsSubject;
    }

    @Override
    public PooledConnection<I, O> newConnection(Channel channel) {
        return PooledConnection.create(channel, this.poolConfig.getMaxIdleTimeMillis(), ClientChannelMetricEventProvider.INSTANCE, this.eventsSubject);
    }

    @Override
    public void useMetricEventsSubject(MetricEventsSubject<?> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }
}

