/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelOption;
import io.mantisrx.shaded.io.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.io.netty.channel.WriteBufferWaterMark;
import io.mantisrx.shaded.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.mantisrx.shaded.io.netty.handler.codec.LengthFieldPrepender;
import io.mantisrx.shaded.io.netty.handler.codec.compression.JdkZlibDecoder;
import io.mantisrx.shaded.io.netty.handler.codec.compression.JdkZlibEncoder;
import io.mantisrx.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.mantisrx.shaded.io.netty.handler.timeout.IdleStateHandler;
import io.reactivex.mantis.network.push.HeartbeatHandler;
import io.reactivex.mantis.network.push.LegacyTcpPipelineConfigurator;
import io.reactivex.mantis.network.push.PushServer;
import io.reactivex.mantis.network.push.PushTrigger;
import io.reactivex.mantis.network.push.RemoteRxEvent;
import io.reactivex.mantis.network.push.ServerConfig;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.channel.ConnectionHandler;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import mantis.io.reactivex.netty.server.RxServer;
import mantis.io.reactivex.netty.server.ServerBuilder;
import rx.Observable;
import rx.functions.Func1;

public class LegacyTcpPushServer<T>
extends PushServer<T, RemoteRxEvent> {
    private Func1<Map<String, List<String>>, Func1<T, Boolean>> predicate;
    private String name;
    private MetricsRegistry metricsRegistry;

    public LegacyTcpPushServer(PushTrigger<T> trigger, ServerConfig<T> config, Observable<String> serverSignals) {
        super(trigger, config, serverSignals);
        this.predicate = config.getPredicate();
        this.name = config.getName();
        this.metricsRegistry = config.getMetricsRegistry();
    }

    @Override
    public RxServer<?, ?> createServer() {
        RxServer server2 = (RxServer)((ServerBuilder)((ServerBuilder)RxNetty.newTcpServerBuilder(this.port, new ConnectionHandler<RemoteRxEvent, RemoteRxEvent>(){

            @Override
            public Observable<Void> handle(final ObservableConnection<RemoteRxEvent, RemoteRxEvent> newConnection) {
                final InetSocketAddress socketAddress = (InetSocketAddress)newConnection.getChannel().remoteAddress();
                return newConnection.getInput().flatMap(new Func1<RemoteRxEvent, Observable<Void>>(){

                    @Override
                    public Observable<Void> call(RemoteRxEvent incomingRequest) {
                        if (incomingRequest.getType() == RemoteRxEvent.Type.subscribed) {
                            Map<String, String> params = incomingRequest.getSubscribeParameters();
                            String id = null;
                            String slotId = null;
                            String groupId = null;
                            boolean enableSampling = false;
                            long samplingTimeMsec = 0L;
                            HashMap predicateParams = null;
                            if (params != null && !params.isEmpty()) {
                                predicateParams = new HashMap();
                                for (Map.Entry<String, String> entry : params.entrySet()) {
                                    LinkedList<String> values = new LinkedList<String>();
                                    values.add(entry.getValue());
                                    predicateParams.put(entry.getKey(), values);
                                }
                                if (params.containsKey("id")) {
                                    id = params.get("id");
                                }
                                if (params.containsKey("slotId")) {
                                    slotId = params.get("slotId");
                                }
                                if (params.containsKey("groupId")) {
                                    groupId = params.get("groupId");
                                }
                                if (params.containsKey("sample")) {
                                    samplingTimeMsec = Long.parseLong(params.get("sample")) * 1000L;
                                    if (samplingTimeMsec < 50L) {
                                        throw new IllegalArgumentException("Sampling rate too low: " + samplingTimeMsec);
                                    }
                                    enableSampling = true;
                                }
                                if (params.containsKey("sampleMSec")) {
                                    samplingTimeMsec = Long.parseLong(params.get("sampleMSec"));
                                    if (samplingTimeMsec < 50L) {
                                        throw new IllegalArgumentException("Sampling rate too low: " + samplingTimeMsec);
                                    }
                                    enableSampling = true;
                                }
                            }
                            Func1 predicateFunction = null;
                            if (LegacyTcpPushServer.this.predicate != null) {
                                predicateFunction = (Func1)LegacyTcpPushServer.this.predicate.call(predicateParams);
                            }
                            Metrics sseSinkMetrics = new Metrics.Builder().name("DropOperator_outgoing_subject_" + slotId).addCounter("onNext").addCounter("dropped").build();
                            sseSinkMetrics = LegacyTcpPushServer.this.metricsRegistry.registerAndGet(sseSinkMetrics);
                            Counter legacyMsgProcessedCounter = sseSinkMetrics.getCounter("onNext");
                            Counter legacyDroppedWrites = sseSinkMetrics.getCounter("dropped");
                            return LegacyTcpPushServer.this.manageConnection(newConnection, socketAddress.getHostString(), socketAddress.getPort(), groupId, slotId, id, null, false, null, enableSampling, samplingTimeMsec, predicateFunction, null, legacyMsgProcessedCounter, legacyDroppedWrites, null);
                        }
                        return null;
                    }
                });
            }
        }).pipelineConfigurator(new PipelineConfiguratorComposite(new PipelineConfigurator<RemoteRxEvent, RemoteRxEvent>(){

            @Override
            public void configureNewPipeline(ChannelPipeline pipeline) {
                pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(10, 2, 0));
                pipeline.addLast("heartbeat", (ChannelHandler)new HeartbeatHandler());
                pipeline.addLast("gzipInflater", (ChannelHandler)new JdkZlibEncoder(ZlibWrapper.GZIP));
                pipeline.addLast("gzipDeflater", (ChannelHandler)new JdkZlibDecoder(ZlibWrapper.GZIP));
                pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
            }
        }, new LegacyTcpPipelineConfigurator(this.name)))).channelOption(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(0x100000, 0x500000))).build();
        return server2;
    }
}

