/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.mantisrx.shaded.io.netty.channel.ChannelDuplexHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.handler.timeout.IdleState;
import io.mantisrx.shaded.io.netty.handler.timeout.IdleStateEvent;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
extends ChannelDuplexHandler {
    static final Logger logger = LoggerFactory.getLogger(HeartbeatHandler.class);

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e2 = (IdleStateEvent)evt;
            if (e2.state() == IdleState.READER_IDLE) {
                logger.warn("Read idle, due to missed heartbeats, closing connection: " + ctx.channel().remoteAddress());
                ctx.close();
            } else if (e2.state() == IdleState.WRITER_IDLE) {
                ByteBuffer buffer = ByteBuffer.allocate(5);
                buffer.putInt(1);
                buffer.put((byte)6);
                ctx.channel().writeAndFlush(buffer.array());
            }
        }
        super.userEventTriggered(ctx, evt);
    }
}

