/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.resolver;

import io.mantisrx.shaded.io.netty.resolver.InetNameResolver;
import io.mantisrx.shaded.io.netty.util.concurrent.EventExecutor;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import io.mantisrx.shaded.io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor executor) {
        super(executor);
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise2) throws Exception {
        try {
            promise2.setSuccess(SocketUtils.addressByName(inetHost));
        }
        catch (UnknownHostException e2) {
            promise2.setFailure(e2);
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise2) throws Exception {
        try {
            promise2.setSuccess(Arrays.asList(SocketUtils.allAddressesByName(inetHost)));
        }
        catch (UnknownHostException e2) {
            promise2.setFailure(e2);
        }
    }
}

