/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.http.websocketx;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.Unpooled;
import io.mantisrx.shaded.io.netty.handler.codec.base64.Base64;
import io.mantisrx.shaded.io.netty.util.CharsetUtil;
import io.mantisrx.shaded.io.netty.util.concurrent.FastThreadLocal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e2) {
                throw new InternalError("MD5 not supported on this platform - Outdated?");
            }
        }
    };
    private static final FastThreadLocal<MessageDigest> SHA1 = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e2) {
                throw new InternalError("SHA-1 not supported on this platform - Outdated?");
            }
        }
    };

    static byte[] md5(byte[] data2) {
        return WebSocketUtil.digest(MD5, data2);
    }

    static byte[] sha1(byte[] data2) {
        return WebSocketUtil.digest(SHA1, data2);
    }

    private static byte[] digest(FastThreadLocal<MessageDigest> digestFastThreadLocal, byte[] data2) {
        MessageDigest digest = digestFastThreadLocal.get();
        digest.reset();
        return digest.digest(data2);
    }

    static String base64(byte[] data2) {
        ByteBuf encodedData = Unpooled.wrappedBuffer(data2);
        ByteBuf encoded = Base64.encode(encodedData);
        String encodedString = encoded.toString(CharsetUtil.UTF_8);
        encoded.release();
        return encodedString;
    }

    static byte[] randomBytes(int size) {
        byte[] bytes2 = new byte[size];
        for (int index2 = 0; index2 < size; ++index2) {
            bytes2[index2] = (byte)WebSocketUtil.randomNumber(0, 255);
        }
        return bytes2;
    }

    static int randomNumber(int minimum, int maximum) {
        return (int)(Math.random() * (double)maximum + (double)minimum);
    }

    private WebSocketUtil() {
    }
}

