/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.channel;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.buffer.CompositeByteBuf;
import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelOutboundInvoker;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import io.mantisrx.shaded.io.netty.channel.DelegatingChannelPromiseNotifier;
import io.mantisrx.shaded.io.netty.channel.PendingBytesTracker;
import io.mantisrx.shaded.io.netty.util.ReferenceCountUtil;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.PlatformDependent;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLogger;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private final PendingBytesTracker tracker;
    private int readableBytes;

    protected AbstractCoalescingBufferQueue(Channel channel, int initSize) {
        this.bufAndListenerPairs = new ArrayDeque(initSize);
        this.tracker = channel == null ? null : PendingBytesTracker.newTracker(channel);
    }

    public final void addFirst(ByteBuf buf, ChannelPromise promise2) {
        this.addFirst(buf, AbstractCoalescingBufferQueue.toChannelFutureListener(promise2));
    }

    private void addFirst(ByteBuf buf, ChannelFutureListener listener) {
        if (listener != null) {
            this.bufAndListenerPairs.addFirst(listener);
        }
        this.bufAndListenerPairs.addFirst(buf);
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final void add(ByteBuf buf) {
        this.add(buf, (ChannelFutureListener)null);
    }

    public final void add(ByteBuf buf, ChannelPromise promise2) {
        this.add(buf, AbstractCoalescingBufferQueue.toChannelFutureListener(promise2));
    }

    public final void add(ByteBuf buf, ChannelFutureListener listener) {
        this.bufAndListenerPairs.add(buf);
        if (listener != null) {
            this.bufAndListenerPairs.add(listener);
        }
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final ByteBuf removeFirst(ChannelPromise aggregatePromise) {
        Object entry = this.bufAndListenerPairs.poll();
        if (entry == null) {
            return null;
        }
        assert (entry instanceof ByteBuf);
        ByteBuf result = (ByteBuf)entry;
        this.decrementReadableBytes(result.readableBytes());
        entry = this.bufAndListenerPairs.peek();
        if (entry instanceof ChannelFutureListener) {
            aggregatePromise.addListener((ChannelFutureListener)entry);
            this.bufAndListenerPairs.poll();
        }
        return result;
    }

    public final ByteBuf remove(ByteBufAllocator alloc, int bytes2, ChannelPromise aggregatePromise) {
        ObjectUtil.checkPositiveOrZero(bytes2, "bytes");
        ObjectUtil.checkNotNull(aggregatePromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            return this.removeEmptyValue();
        }
        bytes2 = Math.min(bytes2, this.readableBytes);
        ByteBuf toReturn = null;
        ByteBuf entryBuffer = null;
        int originalBytes = bytes2;
        try {
            Object entry;
            while ((entry = this.bufAndListenerPairs.poll()) != null) {
                if (entry instanceof ChannelFutureListener) {
                    aggregatePromise.addListener((ChannelFutureListener)entry);
                    continue;
                }
                entryBuffer = (ByteBuf)entry;
                if (entryBuffer.readableBytes() > bytes2) {
                    this.bufAndListenerPairs.addFirst(entryBuffer);
                    if (bytes2 > 0) {
                        entryBuffer = entryBuffer.readRetainedSlice(bytes2);
                        toReturn = toReturn == null ? this.composeFirst(alloc, entryBuffer) : this.compose(alloc, toReturn, entryBuffer);
                        bytes2 = 0;
                    }
                    break;
                }
                bytes2 -= entryBuffer.readableBytes();
                toReturn = toReturn == null ? this.composeFirst(alloc, entryBuffer) : this.compose(alloc, toReturn, entryBuffer);
                entryBuffer = null;
            }
        }
        catch (Throwable cause) {
            ReferenceCountUtil.safeRelease(entryBuffer);
            ReferenceCountUtil.safeRelease(toReturn);
            aggregatePromise.setFailure(cause);
            PlatformDependent.throwException(cause);
        }
        this.decrementReadableBytes(originalBytes - bytes2);
        return toReturn;
    }

    public final int readableBytes() {
        return this.readableBytes;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public final void releaseAndFailAll(ChannelOutboundInvoker invoker, Throwable cause) {
        this.releaseAndCompleteAll(invoker.newFailedFuture(cause));
    }

    public final void copyTo(AbstractCoalescingBufferQueue dest) {
        dest.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        dest.incrementReadableBytes(this.readableBytes);
    }

    public final void writeAndRemoveAll(ChannelHandlerContext ctx) {
        this.decrementReadableBytes(this.readableBytes);
        Throwable pending = null;
        ByteBuf previousBuf = null;
        while (true) {
            Object entry = this.bufAndListenerPairs.poll();
            try {
                if (entry == null) {
                    if (previousBuf == null) break;
                    ctx.write(previousBuf, ctx.voidPromise());
                    break;
                }
                if (entry instanceof ByteBuf) {
                    if (previousBuf != null) {
                        ctx.write(previousBuf, ctx.voidPromise());
                    }
                    previousBuf = (ByteBuf)entry;
                    continue;
                }
                if (entry instanceof ChannelPromise) {
                    ctx.write(previousBuf, (ChannelPromise)entry);
                    previousBuf = null;
                    continue;
                }
                ctx.write(previousBuf).addListener((ChannelFutureListener)entry);
                previousBuf = null;
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    protected abstract ByteBuf compose(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);

    protected final ByteBuf composeIntoComposite(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next2) {
        CompositeByteBuf composite = alloc.compositeBuffer(this.size() + 2);
        try {
            composite.addComponent(true, cumulation);
            composite.addComponent(true, next2);
        }
        catch (Throwable cause) {
            composite.release();
            PlatformDependent.throwException(cause);
        }
        return composite;
    }

    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first2) {
        return first2;
    }

    protected abstract ByteBuf removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    private void releaseAndCompleteAll(ChannelFuture future2) {
        Object entry;
        this.decrementReadableBytes(this.readableBytes);
        Throwable pending = null;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (entry instanceof ByteBuf) {
                    ReferenceCountUtil.safeRelease(entry);
                    continue;
                }
                ((ChannelFutureListener)entry).operationComplete(future2);
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    private void incrementReadableBytes(int increment) {
        int nextReadableBytes = this.readableBytes + increment;
        if (nextReadableBytes < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + increment);
        }
        this.readableBytes = nextReadableBytes;
        if (this.tracker != null) {
            this.tracker.incrementPendingOutboundBytes(increment);
        }
    }

    private void decrementReadableBytes(int decrement) {
        this.readableBytes -= decrement;
        assert (this.readableBytes >= 0);
        if (this.tracker != null) {
            this.tracker.decrementPendingOutboundBytes(decrement);
        }
    }

    private static ChannelFutureListener toChannelFutureListener(ChannelPromise promise2) {
        return promise2.isVoid() ? null : new DelegatingChannelPromiseNotifier(promise2);
    }
}

