/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.buffer;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.buffer.SwappedByteBuf;
import io.mantisrx.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import io.mantisrx.shaded.io.netty.buffer.UnsafeByteBufUtil;
import io.mantisrx.shaded.io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.mantisrx.shaded.io.netty.util.internal.PlatformDependent;

class UnpooledUnsafeHeapByteBuf
extends UnpooledHeapByteBuf {
    UnpooledUnsafeHeapByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(alloc, initialCapacity, maxCapacity);
    }

    @Override
    byte[] allocateArray(int initialCapacity) {
        return PlatformDependent.allocateUninitializedArray(initialCapacity);
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2);
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte(this.array, index2);
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort(this.array, index2);
    }

    @Override
    public short getShortLE(int index2) {
        this.checkIndex(index2, 2);
        return this._getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return UnsafeByteBufUtil.getShortLE(this.array, index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.array, index2);
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.array, index2);
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt(this.array, index2);
    }

    @Override
    public int getIntLE(int index2) {
        this.checkIndex(index2, 4);
        return this._getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return UnsafeByteBufUtil.getIntLE(this.array, index2);
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong(this.array, index2);
    }

    @Override
    public long getLongLE(int index2) {
        this.checkIndex(index2, 8);
        return this._getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return UnsafeByteBufUtil.getLongLE(this.array, index2);
    }

    @Override
    public ByteBuf setByte(int index2, int value) {
        this.checkIndex(index2);
        this._setByte(index2, value);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value) {
        UnsafeByteBufUtil.setByte(this.array, index2, value);
    }

    @Override
    public ByteBuf setShort(int index2, int value) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value) {
        UnsafeByteBufUtil.setShort(this.array, index2, value);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value) {
        this.checkIndex(index2, 2);
        this._setShortLE(index2, value);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        UnsafeByteBufUtil.setShortLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setMedium(int index2, int value) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value) {
        UnsafeByteBufUtil.setMedium(this.array, index2, value);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value) {
        this.checkIndex(index2, 3);
        this._setMediumLE(index2, value);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        UnsafeByteBufUtil.setMediumLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setInt(int index2, int value) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value) {
        UnsafeByteBufUtil.setInt(this.array, index2, value);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value) {
        this.checkIndex(index2, 4);
        this._setIntLE(index2, value);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        UnsafeByteBufUtil.setIntLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setLong(int index2, long value) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value) {
        UnsafeByteBufUtil.setLong(this.array, index2, value);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value) {
        this.checkIndex(index2, 8);
        this._setLongLE(index2, value);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        UnsafeByteBufUtil.setLongLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setZero(int index2, int length) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(index2, length);
            UnsafeByteBufUtil.setZero(this.array, index2, length);
            return this;
        }
        return super.setZero(index2, length);
    }

    @Override
    public ByteBuf writeZero(int length) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.ensureWritable(length);
            int wIndex = this.writerIndex;
            UnsafeByteBufUtil.setZero(this.array, wIndex, length);
            this.writerIndex = wIndex + length;
            return this;
        }
        return super.writeZero(length);
    }

    @Override
    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

