/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.buffer;

import io.mantisrx.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.buffer.HeapByteBufUtil;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    public UnpooledHeapByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(maxCapacity);
        ObjectUtil.checkNotNull(alloc, "alloc");
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, maxCapacity));
        }
        this.alloc = alloc;
        this.setArray(this.allocateArray(initialCapacity));
        this.setIndex(0, 0);
    }

    protected UnpooledHeapByteBuf(ByteBufAllocator alloc, byte[] initialArray, int maxCapacity) {
        super(maxCapacity);
        ObjectUtil.checkNotNull(alloc, "alloc");
        ObjectUtil.checkNotNull(initialArray, "initialArray");
        if (initialArray.length > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialArray.length, maxCapacity));
        }
        this.alloc = alloc;
        this.setArray(initialArray);
        this.setIndex(0, initialArray.length);
    }

    byte[] allocateArray(int initialCapacity) {
        return new byte[initialCapacity];
    }

    void freeArray(byte[] array2) {
    }

    private void setArray(byte[] initialArray) {
        this.array = initialArray;
        this.tmpNioBuf = null;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        this.ensureAccessible();
        return this.array.length;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        int oldCapacity = this.array.length;
        byte[] oldArray = this.array;
        if (newCapacity > oldCapacity) {
            byte[] newArray = this.allocateArray(newCapacity);
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            this.setArray(newArray);
            this.freeArray(oldArray);
        } else if (newCapacity < oldCapacity) {
            byte[] newArray = this.allocateArray(newCapacity);
            int readerIndex = this.readerIndex();
            if (readerIndex < newCapacity) {
                int writerIndex = this.writerIndex();
                if (writerIndex > newCapacity) {
                    writerIndex = newCapacity;
                    this.writerIndex(writerIndex);
                }
                System.arraycopy(oldArray, readerIndex, newArray, readerIndex, writerIndex - readerIndex);
            } else {
                this.setIndex(newCapacity, newCapacity);
            }
            this.setArray(newArray);
            this.freeArray(oldArray);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.array, index2, dst.memoryAddress() + (long)dstIndex, (long)length);
        } else if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, this.array, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.length);
        System.arraycopy(this.array, index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex(index2, dst.remaining());
        dst.put(this.array, index2, dst.remaining());
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.ensureAccessible();
        out.write(this.array, index2, length);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        this.ensureAccessible();
        return this.getBytes(index2, out, length, false);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
        this.ensureAccessible();
        return this.getBytes(index2, out, position, length, false);
    }

    private int getBytes(int index2, GatheringByteChannel out, int length, boolean internal) throws IOException {
        this.ensureAccessible();
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return out.write((ByteBuffer)tmpBuf.clear().position(index2).limit(index2 + length));
    }

    private int getBytes(int index2, FileChannel out, long position, int length, boolean internal) throws IOException {
        this.ensureAccessible();
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return out.write((ByteBuffer)tmpBuf.clear().position(index2).limit(index2 + length), position);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, length, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, position, length, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index2, length, srcIndex, src.capacity());
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, this.array, index2, (long)length);
        } else if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            src.getBytes(srcIndex, this.array, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index2, length, srcIndex, src.length);
        System.arraycopy(src, srcIndex, this.array, index2, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.ensureAccessible();
        src.get(this.array, index2, src.remaining());
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        this.ensureAccessible();
        return in.read(this.array, index2, length);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        this.ensureAccessible();
        try {
            return in.read((ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length));
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
        this.ensureAccessible();
        try {
            return in.read((ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length), position);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, index2, length).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return new ByteBuffer[]{this.nioBuffer(index2, length)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length);
    }

    @Override
    public byte getByte(int index2) {
        this.ensureAccessible();
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return HeapByteBufUtil.getByte(this.array, index2);
    }

    @Override
    public short getShort(int index2) {
        this.ensureAccessible();
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return HeapByteBufUtil.getShort(this.array, index2);
    }

    @Override
    public short getShortLE(int index2) {
        this.ensureAccessible();
        return this._getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return HeapByteBufUtil.getShortLE(this.array, index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return HeapByteBufUtil.getUnsignedMedium(this.array, index2);
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return HeapByteBufUtil.getUnsignedMediumLE(this.array, index2);
    }

    @Override
    public int getInt(int index2) {
        this.ensureAccessible();
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return HeapByteBufUtil.getInt(this.array, index2);
    }

    @Override
    public int getIntLE(int index2) {
        this.ensureAccessible();
        return this._getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return HeapByteBufUtil.getIntLE(this.array, index2);
    }

    @Override
    public long getLong(int index2) {
        this.ensureAccessible();
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return HeapByteBufUtil.getLong(this.array, index2);
    }

    @Override
    public long getLongLE(int index2) {
        this.ensureAccessible();
        return this._getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return HeapByteBufUtil.getLongLE(this.array, index2);
    }

    @Override
    public ByteBuf setByte(int index2, int value) {
        this.ensureAccessible();
        this._setByte(index2, value);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value) {
        HeapByteBufUtil.setByte(this.array, index2, value);
    }

    @Override
    public ByteBuf setShort(int index2, int value) {
        this.ensureAccessible();
        this._setShort(index2, value);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value) {
        HeapByteBufUtil.setShort(this.array, index2, value);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value) {
        this.ensureAccessible();
        this._setShortLE(index2, value);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        HeapByteBufUtil.setShortLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setMedium(int index2, int value) {
        this.ensureAccessible();
        this._setMedium(index2, value);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value) {
        HeapByteBufUtil.setMedium(this.array, index2, value);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value) {
        this.ensureAccessible();
        this._setMediumLE(index2, value);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        HeapByteBufUtil.setMediumLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setInt(int index2, int value) {
        this.ensureAccessible();
        this._setInt(index2, value);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value) {
        HeapByteBufUtil.setInt(this.array, index2, value);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value) {
        this.ensureAccessible();
        this._setIntLE(index2, value);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        HeapByteBufUtil.setIntLE(this.array, index2, value);
    }

    @Override
    public ByteBuf setLong(int index2, long value) {
        this.ensureAccessible();
        this._setLong(index2, value);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value) {
        HeapByteBufUtil.setLong(this.array, index2, value);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value) {
        this.ensureAccessible();
        this._setLongLE(index2, value);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        HeapByteBufUtil.setLongLE(this.array, index2, value);
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex(index2, length);
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.array, index2, copiedArray, 0, length);
        return new UnpooledHeapByteBuf(this.alloc(), copiedArray, this.maxCapacity());
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = ByteBuffer.wrap(this.array);
        }
        return tmpNioBuf;
    }

    @Override
    protected void deallocate() {
        this.freeArray(this.array);
        this.array = null;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

