/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.HttpClientFactory;
import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import mantis.io.reactivex.netty.protocol.http.client.HttpClient;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEvent;

public class HttpClientFactories {
    public static HttpClientFactory<ByteBuf, ByteBuf> defaultFactory() {
        return new DefaultHttpClientFactory();
    }

    public static HttpClientFactory<ByteBuf, ServerSentEvent> sseClientFactory() {
        return new SSEClientFactory();
    }

    public static HttpClientFactory<ByteBuf, ServerSentEvent> sseClientFactory(int readTimeout) {
        return new SSEClientFactory(readTimeout);
    }

    private static class SSEClientFactory
    implements HttpClientFactory<ByteBuf, ServerSentEvent> {
        public static final int DEFAULT_READ_TIMEOUT_SECS = 5;
        private int readTimeout = 5;

        public SSEClientFactory(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public SSEClientFactory() {
            this(5);
        }

        @Override
        public HttpClient<ByteBuf, ServerSentEvent> createClient(RxClient.ServerInfo server2) {
            return RxNetty.createHttpClient(server2.getHost(), server2.getPort(), PipelineConfigurators.clientSseConfigurator());
        }
    }

    private static class DefaultHttpClientFactory
    implements HttpClientFactory<ByteBuf, ByteBuf> {
        private final RxClient.ClientConfig clientConfig = new HttpClient.HttpClientConfig.Builder().setFollowRedirect(true).userAgent("Netflix Mantis HTTP Source").build();

        @Override
        public HttpClient<ByteBuf, ByteBuf> createClient(RxClient.ServerInfo server2) {
            return (HttpClient)((HttpClientBuilder)new HttpClientBuilder(server2.getHost(), server2.getPort()).config(this.clientConfig)).build();
        }
    }
}

