/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.writer.metrics;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;

public class WriterMetrics {
    public static final String OPEN_SUCCESS_COUNT = "openSuccessCount";
    private final Counter openSuccessCount;
    public static final String OPEN_FAILURE_COUNT = "openFailureCount";
    private final Counter openFailureCount;
    public static final String WRITE_SUCCESS_COUNT = "writeSuccessCount";
    private final Counter writeSuccessCount;
    public static final String WRITE_FAILURE_COUNT = "writeFailureCount";
    private final Counter writeFailureCount;
    public static final String BATCH_SUCCESS_COUNT = "batchSuccessCount";
    private final Counter batchSuccessCount;
    public static final String BATCH_FAILURE_COUNT = "batchFailureCount";
    private final Counter batchFailureCount;
    public static final String BATCH_SIZE = "batchSize";
    private final Gauge batchSize;
    public static final String BATCH_SIZE_BYTES = "batchSizeBytes";
    private final Gauge batchSizeBytes;

    public WriterMetrics() {
        Metrics metrics = new Metrics.Builder().name(WriterMetrics.class.getCanonicalName()).addCounter(OPEN_SUCCESS_COUNT).addCounter(OPEN_FAILURE_COUNT).addCounter(WRITE_SUCCESS_COUNT).addCounter(WRITE_FAILURE_COUNT).addCounter(BATCH_SUCCESS_COUNT).addCounter(BATCH_FAILURE_COUNT).addGauge(BATCH_SIZE).addGauge(BATCH_SIZE_BYTES).build();
        metrics = MetricsRegistry.getInstance().registerAndGet(metrics);
        this.openSuccessCount = metrics.getCounter(OPEN_SUCCESS_COUNT);
        this.openFailureCount = metrics.getCounter(OPEN_FAILURE_COUNT);
        this.writeSuccessCount = metrics.getCounter(WRITE_SUCCESS_COUNT);
        this.writeFailureCount = metrics.getCounter(WRITE_FAILURE_COUNT);
        this.batchSuccessCount = metrics.getCounter(BATCH_SUCCESS_COUNT);
        this.batchFailureCount = metrics.getCounter(BATCH_FAILURE_COUNT);
        this.batchSize = metrics.getGauge(BATCH_SIZE);
        this.batchSizeBytes = metrics.getGauge(BATCH_SIZE_BYTES);
    }

    public void setGauge(String metric, long value) {
        switch (metric) {
            case "batchSize": {
                this.batchSize.set(value);
                break;
            }
            case "batchSizeBytes": {
                this.batchSizeBytes.set(value);
                break;
            }
        }
    }

    public void increment(String metric) {
        switch (metric) {
            case "openSuccessCount": {
                this.openSuccessCount.increment();
                break;
            }
            case "openFailureCount": {
                this.openFailureCount.increment();
                break;
            }
            case "writeSuccessCount": {
                this.writeSuccessCount.increment();
                break;
            }
            case "writeFailureCount": {
                this.writeFailureCount.increment();
                break;
            }
            case "batchSuccessCount": {
                this.batchSuccessCount.increment();
                break;
            }
            case "batchFailureCount": {
                this.batchFailureCount.increment();
                break;
            }
        }
    }

    public void increment(String metric, long value) {
        switch (metric) {
            case "openSuccessCount": {
                this.openSuccessCount.increment(value);
                break;
            }
            case "openFailureCount": {
                this.openFailureCount.increment(value);
                break;
            }
            case "writeSuccessCount": {
                this.writeSuccessCount.increment(value);
                break;
            }
            case "writeFailureCount": {
                this.writeFailureCount.increment(value);
                break;
            }
            case "batchSuccessCount": {
                this.batchSuccessCount.increment(value);
                break;
            }
            case "batchFailureCount": {
                this.batchFailureCount.increment(value);
                break;
            }
        }
    }
}

