/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func2;
import rx.observers.Subscribers;

public final class OperatorZipIterable<T1, T2, R>
implements Observable.Operator<R, T1> {
    final Iterable<? extends T2> iterable;
    final Func2<? super T1, ? super T2, ? extends R> zipFunction;

    public OperatorZipIterable(Iterable<? extends T2> iterable, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        this.iterable = iterable;
        this.zipFunction = zipFunction;
    }

    @Override
    public Subscriber<? super T1> call(final Subscriber<? super R> subscriber2) {
        final Iterator<T2> iterator = this.iterable.iterator();
        try {
            if (!iterator.hasNext()) {
                subscriber2.onCompleted();
                return Subscribers.empty();
            }
        }
        catch (Throwable e2) {
            Exceptions.throwOrReport(e2, subscriber2);
            return Subscribers.empty();
        }
        return new Subscriber<T1>(subscriber2){
            boolean done;

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                subscriber2.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                if (this.done) {
                    Exceptions.throwIfFatal(e2);
                    return;
                }
                this.done = true;
                subscriber2.onError(e2);
            }

            @Override
            public void onNext(T1 t) {
                if (this.done) {
                    return;
                }
                try {
                    subscriber2.onNext(OperatorZipIterable.this.zipFunction.call(t, iterator.next()));
                    if (!iterator.hasNext()) {
                        this.onCompleted();
                    }
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, this);
                }
            }
        };
    }
}

