/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutorGroup;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import mantis.io.reactivex.netty.protocol.http.server.ServerRequestResponseConverter;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

class ServerRequiredConfigurator<I, O>
implements PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> {
    public static final String REQUEST_RESPONSE_CONVERTER_HANDLER_NAME = "request-response-converter";
    private final EventExecutorGroup handlersExecutorGroup;
    private final long requestContentSubscriptionTimeoutMs;
    private MetricEventsSubject<ServerMetricsEvent<?>> eventsSubject;

    ServerRequiredConfigurator(EventExecutorGroup handlersExecutorGroup, long requestContentSubscriptionTimeoutMs) {
        this.handlersExecutorGroup = handlersExecutorGroup;
        this.requestContentSubscriptionTimeoutMs = requestContentSubscriptionTimeoutMs;
    }

    void useMetricEventsSubject(MetricEventsSubject<ServerMetricsEvent<?>> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(this.getRequestResponseConverterExecutor(), REQUEST_RESPONSE_CONVERTER_HANDLER_NAME, (ChannelHandler)new ServerRequestResponseConverter(this.eventsSubject, this.requestContentSubscriptionTimeoutMs));
    }

    protected EventExecutorGroup getRequestResponseConverterExecutor() {
        return this.handlersExecutorGroup;
    }
}

