/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeTimeout
implements Completable.OnSubscribe {
    final Completable source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Completable other;

    public CompletableOnSubscribeTimeout(Completable source2, long timeout, TimeUnit unit, Scheduler scheduler, Completable other) {
        this.source = source2;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void call(final CompletableSubscriber s) {
        final CompositeSubscription set2 = new CompositeSubscription();
        s.onSubscribe(set2);
        final AtomicBoolean once = new AtomicBoolean();
        Scheduler.Worker w = this.scheduler.createWorker();
        set2.add(w);
        w.schedule(new Action0(){

            @Override
            public void call() {
                if (once.compareAndSet(false, true)) {
                    set2.clear();
                    if (CompletableOnSubscribeTimeout.this.other == null) {
                        s.onError(new TimeoutException());
                    } else {
                        CompletableOnSubscribeTimeout.this.other.unsafeSubscribe(new CompletableSubscriber(){

                            @Override
                            public void onSubscribe(Subscription d) {
                                set2.add(d);
                            }

                            @Override
                            public void onError(Throwable e2) {
                                set2.unsubscribe();
                                s.onError(e2);
                            }

                            @Override
                            public void onCompleted() {
                                set2.unsubscribe();
                                s.onCompleted();
                            }
                        });
                    }
                }
            }
        }, this.timeout, this.unit);
        this.source.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onSubscribe(Subscription d) {
                set2.add(d);
            }

            @Override
            public void onError(Throwable e2) {
                if (once.compareAndSet(false, true)) {
                    set2.unsubscribe();
                    s.onError(e2);
                } else {
                    RxJavaHooks.onError(e2);
                }
            }

            @Override
            public void onCompleted() {
                if (once.compareAndSet(false, true)) {
                    set2.unsubscribe();
                    s.onCompleted();
                }
            }
        });
    }
}

