/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import java.util.concurrent.ScheduledExecutorService;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.client.ClientChannelFactory;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.ConnectionPoolBuilder;
import mantis.io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import mantis.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;

public abstract class AbstractClientBuilder<I, O, B extends AbstractClientBuilder, C extends RxClient<I, O>> {
    private String name;
    protected final RxClient.ServerInfo serverInfo;
    protected final Bootstrap bootstrap;
    protected final ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory;
    protected ClientChannelFactory<O, I> channelFactory;
    protected ConnectionPoolBuilder<O, I> poolBuilder;
    protected PipelineConfigurator<O, I> pipelineConfigurator;
    protected Class<? extends Channel> socketChannel;
    protected EventLoopGroup eventLoopGroup;
    protected RxClient.ClientConfig clientConfig;
    protected LogLevel wireLogginLevel;
    protected MetricEventsListenerFactory eventListenersFactory;
    protected MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject = new MetricEventsSubject();
    private SSLEngineFactory sslEngineFactory;

    protected AbstractClientBuilder(Bootstrap bootstrap, String host, int port, ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory, ClientChannelFactory<O, I> factory) {
        factory.useMetricEventsSubject(this.eventsSubject);
        connectionFactory.useMetricEventsSubject(this.eventsSubject);
        this.bootstrap = bootstrap;
        this.serverInfo = new RxClient.ServerInfo(host, port);
        this.clientConfig = RxClient.ClientConfig.Builder.newDefaultConfig();
        this.connectionFactory = connectionFactory;
        this.channelFactory = factory;
        this.poolBuilder = null;
        this.defaultChannelOptions();
    }

    protected AbstractClientBuilder(Bootstrap bootstrap, String host, int port, ConnectionPoolBuilder<O, I> poolBuilder) {
        this.bootstrap = bootstrap;
        this.poolBuilder = poolBuilder;
        this.serverInfo = new RxClient.ServerInfo(host, port);
        this.clientConfig = RxClient.ClientConfig.Builder.newDefaultConfig();
        this.connectionFactory = null;
        this.channelFactory = null;
        this.defaultChannelOptions();
    }

    public B defaultChannelOptions() {
        return this.channelOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
    }

    public B defaultTcpOptions() {
        this.defaultChannelOptions();
        this.channelOption(ChannelOption.SO_KEEPALIVE, true);
        return this.channelOption(ChannelOption.TCP_NODELAY, true);
    }

    public B defaultUdpOptions() {
        this.defaultChannelOptions();
        return this.channelOption(ChannelOption.SO_BROADCAST, true);
    }

    public B pipelineConfigurator(PipelineConfigurator<O, I> pipelineConfigurator) {
        this.pipelineConfigurator = pipelineConfigurator;
        return this.returnBuilder();
    }

    public <T> B channelOption(ChannelOption<T> option, T value) {
        this.bootstrap.option(option, value);
        return this.returnBuilder();
    }

    public B channel(Class<? extends Channel> socketChannel) {
        this.socketChannel = socketChannel;
        return this.returnBuilder();
    }

    public B eventloop(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this.returnBuilder();
    }

    public B config(RxClient.ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this.returnBuilder();
    }

    public B withMaxConnections(int maxConnections) {
        this.getPoolBuilder(true).withMaxConnections(maxConnections);
        return this.returnBuilder();
    }

    public B withIdleConnectionsTimeoutMillis(long idleConnectionsTimeoutMillis) {
        this.getPoolBuilder(true).withIdleConnectionsTimeoutMillis(idleConnectionsTimeoutMillis);
        return this.returnBuilder();
    }

    public B withConnectionPoolLimitStrategy(PoolLimitDeterminationStrategy limitDeterminationStrategy) {
        this.getPoolBuilder(true).withConnectionPoolLimitStrategy(limitDeterminationStrategy);
        return this.returnBuilder();
    }

    public B withPoolIdleCleanupScheduler(ScheduledExecutorService poolIdleCleanupScheduler) {
        this.getPoolBuilder(true).withPoolIdleCleanupScheduler(poolIdleCleanupScheduler);
        return this.returnBuilder();
    }

    public B withNoIdleConnectionCleanup() {
        this.getPoolBuilder(true).withNoIdleConnectionCleanup();
        return this.returnBuilder();
    }

    public PipelineConfigurator<O, I> getPipelineConfigurator() {
        return this.pipelineConfigurator;
    }

    public B appendPipelineConfigurator(PipelineConfigurator<O, I> additionalConfigurator) {
        return this.pipelineConfigurator(PipelineConfigurators.composeConfigurators(this.pipelineConfigurator, additionalConfigurator));
    }

    public B withChannelFactory(ClientChannelFactory<O, I> factory) {
        ConnectionPoolBuilder<O, I> builder = this.getPoolBuilder(false);
        if (null != builder) {
            builder.withChannelFactory(factory);
        } else {
            this.channelFactory = factory;
        }
        return this.returnBuilder();
    }

    public B enableWireLogging(LogLevel wireLogginLevel) {
        this.wireLogginLevel = wireLogginLevel;
        return this.returnBuilder();
    }

    public B withName(String name2) {
        this.name = name2;
        return this.returnBuilder();
    }

    public B withMetricEventsListenerFactory(MetricEventsListenerFactory eventListenersFactory) {
        this.eventListenersFactory = eventListenersFactory;
        return this.returnBuilder();
    }

    public B withNoConnectionPooling() {
        this.poolBuilder = null;
        return this.returnBuilder();
    }

    public B withSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
        return this.returnBuilder();
    }

    public B disableAutoReleaseBuffers() {
        this.bootstrap.attr(ObservableConnection.AUTO_RELEASE_BUFFERS, false);
        return this.returnBuilder();
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public RxClient.ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public MetricEventsSubject<ClientMetricsEvent<?>> getEventsSubject() {
        return this.eventsSubject;
    }

    public C build() {
        if (null == this.socketChannel) {
            this.socketChannel = this.defaultSocketChannelClass();
            if (null == this.eventLoopGroup) {
                this.eventLoopGroup = this.defaultEventloop(this.socketChannel);
            }
        }
        if (null == this.eventLoopGroup) {
            if (this.defaultSocketChannelClass() == this.socketChannel) {
                this.eventLoopGroup = this.defaultEventloop(this.socketChannel);
            } else {
                throw new IllegalStateException("Specified a channel class but not the event loop group.");
            }
        }
        ((Bootstrap)this.bootstrap.channel(this.socketChannel)).group(this.eventLoopGroup);
        if (null != this.wireLogginLevel) {
            this.pipelineConfigurator = PipelineConfigurators.appendLoggingConfigurator(this.pipelineConfigurator, this.wireLogginLevel);
        }
        if (null != this.sslEngineFactory) {
            this.appendPipelineConfigurator(PipelineConfigurators.sslConfigurator(this.sslEngineFactory));
        }
        C client = this.createClient();
        if (null != this.eventListenersFactory) {
            MetricEventsListener<ClientMetricsEvent<Enum>> listener = this.newMetricsListener(this.eventListenersFactory, client);
            client.subscribe(listener);
        }
        return client;
    }

    protected EventLoopGroup defaultEventloop(Class<? extends Channel> socketChannel) {
        return RxNetty.getRxEventLoopProvider().globalClientEventLoop();
    }

    protected Class<? extends SocketChannel> defaultSocketChannelClass() {
        return NioSocketChannel.class;
    }

    protected abstract C createClient();

    protected B returnBuilder() {
        return (B)this;
    }

    protected ConnectionPoolBuilder<O, I> getPoolBuilder(boolean createNew) {
        if (null == this.poolBuilder && createNew) {
            this.poolBuilder = new ConnectionPoolBuilder<I, O>(this.serverInfo, this.channelFactory, this.eventsSubject);
        }
        return this.poolBuilder;
    }

    protected String getOrCreateName() {
        if (null != this.name) {
            return this.name;
        }
        this.name = this.generatedNamePrefix() + "-no-name";
        return this.name;
    }

    protected String generatedNamePrefix() {
        return "RxClient-";
    }

    protected abstract MetricEventsListener<? extends ClientMetricsEvent<? extends Enum>> newMetricsListener(MetricEventsListenerFactory var1, C var2);
}

