/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

final class Bzip2DivSufSort {
    private static final int STACK_SIZE = 64;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int INSERTIONSORT_THRESHOLD = 8;
    private static final int[] LOG_2_TABLE = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final int[] SA;
    private final byte[] T;
    private final int n;

    Bzip2DivSufSort(byte[] block, int[] bwtBlock, int blockLength) {
        this.T = block;
        this.SA = bwtBlock;
        this.n = blockLength;
    }

    private static void swapElements(int[] array1, int idx1, int[] array2, int idx2) {
        int temp = array1[idx1];
        array1[idx1] = array2[idx2];
        array2[idx2] = temp;
    }

    private int ssCompare(int p1, int p2, int depth) {
        int U2;
        int[] SA = this.SA;
        byte[] T = this.T;
        int U1n = SA[p1 + 1] + 2;
        int U2n = SA[p2 + 1] + 2;
        int U1 = depth + SA[p1];
        for (U2 = depth + SA[p2]; U1 < U1n && U2 < U2n && T[U1] == T[U2]; ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1) : (U2 < U2n ? -1 : 0);
    }

    private int ssCompareLast(int pa, int p1, int p2, int depth, int size) {
        int U2;
        int[] SA = this.SA;
        byte[] T = this.T;
        int U1 = depth + SA[p1];
        int U1n = size;
        int U2n = SA[p2 + 1] + 2;
        for (U2 = depth + SA[p2]; U1 < U1n && U2 < U2n && T[U1] == T[U2]; ++U1, ++U2) {
        }
        if (U1 < U1n) {
            return U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1;
        }
        if (U2 == U2n) {
            return 1;
        }
        U1 %= size;
        U1n = SA[pa] + 2;
        while (U1 < U1n && U2 < U2n && T[U1] == T[U2]) {
            ++U1;
            ++U2;
        }
        return U1 < U1n ? (U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1) : (U2 < U2n ? -1 : 0);
    }

    private void ssInsertionSort(int pa, int first2, int last2, int depth) {
        int[] SA = this.SA;
        for (int i = last2 - 2; first2 <= i; --i) {
            int r;
            int t = SA[i];
            int j = i + 1;
            while (0 < (r = this.ssCompare(pa + t, pa + SA[j], depth))) {
                do {
                    SA[j - 1] = SA[j];
                } while (++j < last2 && SA[j] < 0);
                if (last2 > j) continue;
            }
            if (r == 0) {
                SA[j] = ~SA[j];
            }
            SA[j - 1] = t;
        }
    }

    private void ssFixdown(int td, int pa, int sa, int i, int size) {
        int j;
        int[] SA = this.SA;
        byte[] T = this.T;
        int v = SA[sa + i];
        int c = T[td + SA[pa + v]] & 0xFF;
        while ((j = 2 * i + 1) < size) {
            int e2;
            int k;
            int d;
            if ((d = T[td + SA[pa + SA[sa + (k = j++)]]] & 0xFF) < (e2 = T[td + SA[pa + SA[sa + j]]] & 0xFF)) {
                k = j;
                d = e2;
            }
            if (d <= c) break;
            SA[sa + i] = SA[sa + k];
            i = k;
        }
        SA[sa + i] = v;
    }

    private void ssHeapSort(int td, int pa, int sa, int size) {
        int i;
        int[] SA = this.SA;
        byte[] T = this.T;
        int m = size;
        if (size % 2 == 0 && (T[td + SA[pa + SA[sa + --m / 2]]] & 0xFF) < (T[td + SA[pa + SA[sa + m]]] & 0xFF)) {
            Bzip2DivSufSort.swapElements(SA, sa + m, SA, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.ssFixdown(td, pa, sa, i, m);
        }
        if (size % 2 == 0) {
            Bzip2DivSufSort.swapElements(SA, sa, SA, sa + m);
            this.ssFixdown(td, pa, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = SA[sa];
            SA[sa] = SA[sa + i];
            this.ssFixdown(td, pa, sa, 0, i);
            SA[sa + i] = t;
        }
    }

    private int ssMedian3(int td, int pa, int v1, int v2, int v3) {
        int[] SA = this.SA;
        byte[] T = this.T;
        int T_v1 = T[td + SA[pa + SA[v1]]] & 0xFF;
        int T_v2 = T[td + SA[pa + SA[v2]]] & 0xFF;
        int T_v3 = T[td + SA[pa + SA[v3]]] & 0xFF;
        if (T_v1 > T_v2) {
            int temp = v1;
            v1 = v2;
            v2 = temp;
            int T_vtemp = T_v1;
            T_v1 = T_v2;
            T_v2 = T_vtemp;
        }
        if (T_v2 > T_v3) {
            if (T_v1 > T_v3) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private int ssMedian5(int td, int pa, int v1, int v2, int v3, int v4, int v5) {
        int T_vtemp;
        int temp;
        int[] SA = this.SA;
        byte[] T = this.T;
        int T_v1 = T[td + SA[pa + SA[v1]]] & 0xFF;
        int T_v2 = T[td + SA[pa + SA[v2]]] & 0xFF;
        int T_v3 = T[td + SA[pa + SA[v3]]] & 0xFF;
        int T_v4 = T[td + SA[pa + SA[v4]]] & 0xFF;
        int T_v5 = T[td + SA[pa + SA[v5]]] & 0xFF;
        if (T_v2 > T_v3) {
            temp = v2;
            v2 = v3;
            v3 = temp;
            T_vtemp = T_v2;
            T_v2 = T_v3;
            T_v3 = T_vtemp;
        }
        if (T_v4 > T_v5) {
            temp = v4;
            v4 = v5;
            v5 = temp;
            T_vtemp = T_v4;
            T_v4 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v2 > T_v4) {
            v4 = temp = v2;
            T_v4 = T_vtemp = T_v2;
            temp = v3;
            v3 = v5;
            v5 = temp;
            T_vtemp = T_v3;
            T_v3 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v1 > T_v3) {
            temp = v1;
            v1 = v3;
            v3 = temp;
            T_vtemp = T_v1;
            T_v1 = T_v3;
            T_v3 = T_vtemp;
        }
        if (T_v1 > T_v4) {
            v4 = temp = v1;
            T_v4 = T_vtemp = T_v1;
            v3 = v5;
            T_v3 = T_v5;
        }
        if (T_v3 > T_v4) {
            return v4;
        }
        return v3;
    }

    private int ssPivot(int td, int pa, int first2, int last2) {
        int t = last2 - first2;
        int middle = first2 + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.ssMedian3(td, pa, first2, middle, last2 - 1);
            }
            return this.ssMedian5(td, pa, first2, first2 + (t >>= 2), middle, last2 - 1 - t, last2 - 1);
        }
        return this.ssMedian3(td, pa, this.ssMedian3(td, pa, first2, first2 + (t >>= 3), first2 + (t << 1)), this.ssMedian3(td, pa, middle - t, middle, middle + t), this.ssMedian3(td, pa, last2 - 1 - (t << 1), last2 - 1 - t, last2 - 1));
    }

    private static int ssLog(int n) {
        return (n & 0xFF00) != 0 ? 8 + LOG_2_TABLE[n >> 8 & 0xFF] : LOG_2_TABLE[n & 0xFF];
    }

    private int ssSubstringPartition(int pa, int first2, int last2, int depth) {
        int[] SA = this.SA;
        int a = first2 - 1;
        int b = last2;
        while (true) {
            if (++a < b && SA[pa + SA[a]] + depth >= SA[pa + SA[a] + 1] + 1) {
                SA[a] = ~SA[a];
                continue;
            }
            --b;
            while (a < b && SA[pa + SA[b]] + depth < SA[pa + SA[b] + 1] + 1) {
                --b;
            }
            if (b <= a) break;
            int t = ~SA[b];
            SA[b] = SA[a];
            SA[a] = t;
        }
        if (first2 < a) {
            SA[first2] = ~SA[first2];
        }
        return a;
    }

    private void ssMultiKeyIntroSort(int pa, int first2, int last2, int depth) {
        int[] SA = this.SA;
        byte[] T = this.T;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit2 = Bzip2DivSufSort.ssLog(last2 - first2);
        while (true) {
            int c;
            int b;
            int a;
            int v;
            if (last2 - first2 <= 8) {
                if (1 < last2 - first2) {
                    this.ssInsertionSort(pa, first2, last2, depth);
                }
                if (ssize == 0) {
                    return;
                }
                StackEntry entry = stack[--ssize];
                first2 = entry.a;
                last2 = entry.b;
                depth = entry.c;
                limit2 = entry.d;
                continue;
            }
            int Td = depth;
            if (limit2-- == 0) {
                this.ssHeapSort(Td, pa, first2, last2 - first2);
            }
            if (limit2 < 0) {
                v = T[Td + SA[pa + SA[first2]]] & 0xFF;
                for (a = first2 + 1; a < last2; ++a) {
                    x = T[Td + SA[pa + SA[a]]] & 0xFF;
                    if (x == v) continue;
                    if (1 < a - first2) break;
                    v = x;
                    first2 = a;
                }
                if ((T[Td + SA[pa + SA[first2]] - 1] & 0xFF) < v) {
                    first2 = this.ssSubstringPartition(pa, first2, a, depth);
                }
                if (a - first2 <= last2 - a) {
                    if (1 < a - first2) {
                        stack[ssize++] = new StackEntry(a, last2, depth, -1);
                        last2 = a;
                        ++depth;
                        limit2 = Bzip2DivSufSort.ssLog(a - first2);
                        continue;
                    }
                    first2 = a;
                    limit2 = -1;
                    continue;
                }
                if (1 < last2 - a) {
                    stack[ssize++] = new StackEntry(first2, a, depth + 1, Bzip2DivSufSort.ssLog(a - first2));
                    first2 = a;
                    limit2 = -1;
                    continue;
                }
                last2 = a;
                ++depth;
                limit2 = Bzip2DivSufSort.ssLog(a - first2);
                continue;
            }
            a = this.ssPivot(Td, pa, first2, last2);
            v = T[Td + SA[pa + SA[a]]] & 0xFF;
            Bzip2DivSufSort.swapElements(SA, first2, SA, a);
            for (b = first2 + 1; b < last2 && (x = T[Td + SA[pa + SA[b]]] & 0xFF) == v; ++b) {
            }
            a = b;
            if (a < last2 && x < v) {
                while (++b < last2 && (x = T[Td + SA[pa + SA[b]]] & 0xFF) <= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            for (c = last2 - 1; b < c && (x = T[Td + SA[pa + SA[c]]] & 0xFF) == v; --c) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = T[Td + SA[pa + SA[c]]] & 0xFF) >= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                Bzip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = T[Td + SA[pa + SA[b]]] & 0xFF) <= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = T[Td + SA[pa + SA[c]]] & 0xFF) >= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first2;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e2 = first2;
                int f = b - s;
                while (0 < s) {
                    Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                    --s;
                    ++e2;
                    ++f;
                }
                s = d - c;
                t = last2 - d - 1;
                if (s > t) {
                    s = t;
                }
                e2 = b;
                f = last2 - s;
                while (0 < s) {
                    Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                    --s;
                    ++e2;
                    ++f;
                }
                a = first2 + (b - a);
                c = last2 - (d - c);
                int n = b = v <= (T[Td + SA[pa + SA[a]] - 1] & 0xFF) ? a : this.ssSubstringPartition(pa, a, c, depth);
                if (a - first2 <= last2 - c) {
                    if (last2 - c <= c - b) {
                        stack[ssize++] = new StackEntry(b, c, depth + 1, Bzip2DivSufSort.ssLog(c - b));
                        stack[ssize++] = new StackEntry(c, last2, depth, limit2);
                        last2 = a;
                        continue;
                    }
                    if (a - first2 <= c - b) {
                        stack[ssize++] = new StackEntry(c, last2, depth, limit2);
                        stack[ssize++] = new StackEntry(b, c, depth + 1, Bzip2DivSufSort.ssLog(c - b));
                        last2 = a;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(c, last2, depth, limit2);
                    stack[ssize++] = new StackEntry(first2, a, depth, limit2);
                    first2 = b;
                    last2 = c;
                    ++depth;
                    limit2 = Bzip2DivSufSort.ssLog(c - b);
                    continue;
                }
                if (a - first2 <= c - b) {
                    stack[ssize++] = new StackEntry(b, c, depth + 1, Bzip2DivSufSort.ssLog(c - b));
                    stack[ssize++] = new StackEntry(first2, a, depth, limit2);
                    first2 = c;
                    continue;
                }
                if (last2 - c <= c - b) {
                    stack[ssize++] = new StackEntry(first2, a, depth, limit2);
                    stack[ssize++] = new StackEntry(b, c, depth + 1, Bzip2DivSufSort.ssLog(c - b));
                    first2 = c;
                    continue;
                }
                stack[ssize++] = new StackEntry(first2, a, depth, limit2);
                stack[ssize++] = new StackEntry(c, last2, depth, limit2);
                first2 = b;
                last2 = c;
                ++depth;
                limit2 = Bzip2DivSufSort.ssLog(c - b);
                continue;
            }
            ++limit2;
            if ((T[Td + SA[pa + SA[first2]] - 1] & 0xFF) < v) {
                first2 = this.ssSubstringPartition(pa, first2, last2, depth);
                limit2 = Bzip2DivSufSort.ssLog(last2 - first2);
            }
            ++depth;
        }
    }

    private static void ssBlockSwap(int[] array1, int first1, int[] array2, int first2, int size) {
        int i = size;
        int a = first1;
        int b = first2;
        while (0 < i) {
            Bzip2DivSufSort.swapElements(array1, a, array2, b);
            --i;
            ++a;
            ++b;
        }
    }

    private void ssMergeForward(int pa, int[] buf, int bufoffset, int first2, int middle, int last2, int depth) {
        int[] SA = this.SA;
        int bufend = bufoffset + (middle - first2) - 1;
        Bzip2DivSufSort.ssBlockSwap(buf, bufoffset, SA, first2, middle - first2);
        int t = SA[first2];
        int i = first2;
        int j = bufoffset;
        int k = middle;
        while (true) {
            int r;
            if ((r = this.ssCompare(pa + buf[j], pa + SA[k], depth)) < 0) {
                do {
                    SA[i++] = buf[j];
                    if (bufend <= j) {
                        buf[j] = t;
                        return;
                    }
                    buf[j++] = SA[i];
                } while (buf[j] < 0);
                continue;
            }
            if (r > 0) {
                do {
                    SA[i++] = SA[k];
                    SA[k++] = SA[i];
                    if (last2 > k) continue;
                    while (j < bufend) {
                        SA[i++] = buf[j];
                        buf[j++] = SA[i];
                    }
                    SA[i] = buf[j];
                    buf[j] = t;
                    return;
                } while (SA[k] < 0);
                continue;
            }
            SA[k] = ~SA[k];
            do {
                SA[i++] = buf[j];
                if (bufend <= j) {
                    buf[j] = t;
                    return;
                }
                buf[j++] = SA[i];
            } while (buf[j] < 0);
            do {
                SA[i++] = SA[k];
                SA[k++] = SA[i];
                if (last2 > k) continue;
                while (j < bufend) {
                    SA[i++] = buf[j];
                    buf[j++] = SA[i];
                }
                SA[i] = buf[j];
                buf[j] = t;
                return;
            } while (SA[k] < 0);
        }
    }

    private void ssMergeBackward(int pa, int[] buf, int bufoffset, int first2, int middle, int last2, int depth) {
        int p2;
        int p1;
        int[] SA = this.SA;
        int bufend = bufoffset + (last2 - middle);
        Bzip2DivSufSort.ssBlockSwap(buf, bufoffset, SA, middle, last2 - middle);
        int x = 0;
        if (buf[bufend - 1] < 0) {
            x |= 1;
            p1 = pa + ~buf[bufend - 1];
        } else {
            p1 = pa + buf[bufend - 1];
        }
        if (SA[middle - 1] < 0) {
            x |= 2;
            p2 = pa + ~SA[middle - 1];
        } else {
            p2 = pa + SA[middle - 1];
        }
        int t = SA[last2 - 1];
        int i = last2 - 1;
        int j = bufend - 1;
        int k = middle - 1;
        while (true) {
            int r;
            if ((r = this.ssCompare(p1, p2, depth)) > 0) {
                if ((x & 1) != 0) {
                    do {
                        SA[i--] = buf[j];
                        buf[j--] = SA[i];
                    } while (buf[j] < 0);
                    x ^= 1;
                }
                SA[i--] = buf[j];
                if (j <= bufoffset) {
                    buf[j] = t;
                    return;
                }
                buf[j--] = SA[i];
                if (buf[j] < 0) {
                    x |= 1;
                    p1 = pa + ~buf[j];
                    continue;
                }
                p1 = pa + buf[j];
                continue;
            }
            if (r < 0) {
                if ((x & 2) != 0) {
                    do {
                        SA[i--] = SA[k];
                        SA[k--] = SA[i];
                    } while (SA[k] < 0);
                    x ^= 2;
                }
                SA[i--] = SA[k];
                SA[k--] = SA[i];
                if (k < first2) {
                    while (bufoffset < j) {
                        SA[i--] = buf[j];
                        buf[j--] = SA[i];
                    }
                    SA[i] = buf[j];
                    buf[j] = t;
                    return;
                }
                if (SA[k] < 0) {
                    x |= 2;
                    p2 = pa + ~SA[k];
                    continue;
                }
                p2 = pa + SA[k];
                continue;
            }
            if ((x & 1) != 0) {
                do {
                    SA[i--] = buf[j];
                    buf[j--] = SA[i];
                } while (buf[j] < 0);
                x ^= 1;
            }
            SA[i--] = ~buf[j];
            if (j <= bufoffset) {
                buf[j] = t;
                return;
            }
            buf[j--] = SA[i];
            if ((x & 2) != 0) {
                do {
                    SA[i--] = SA[k];
                    SA[k--] = SA[i];
                } while (SA[k] < 0);
                x ^= 2;
            }
            SA[i--] = SA[k];
            SA[k--] = SA[i];
            if (k < first2) {
                while (bufoffset < j) {
                    SA[i--] = buf[j];
                    buf[j--] = SA[i];
                }
                SA[i] = buf[j];
                buf[j] = t;
                return;
            }
            if (buf[j] < 0) {
                x |= 1;
                p1 = pa + ~buf[j];
            } else {
                p1 = pa + buf[j];
            }
            if (SA[k] < 0) {
                x |= 2;
                p2 = pa + ~SA[k];
                continue;
            }
            p2 = pa + SA[k];
        }
    }

    private static int getIDX(int a) {
        return 0 <= a ? a : ~a;
    }

    private void ssMergeCheckEqual(int pa, int depth, int a) {
        int[] SA = this.SA;
        if (0 <= SA[a] && this.ssCompare(pa + Bzip2DivSufSort.getIDX(SA[a - 1]), pa + SA[a], depth) == 0) {
            SA[a] = ~SA[a];
        }
    }

    private void ssMerge(int pa, int first2, int middle, int last2, int[] buf, int bufoffset, int bufsize, int depth) {
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int check = 0;
        int ssize = 0;
        while (true) {
            StackEntry entry;
            if (last2 - middle <= bufsize) {
                if (first2 < middle && middle < last2) {
                    this.ssMergeBackward(pa, buf, bufoffset, first2, middle, last2, depth);
                }
                if (check & true) {
                    this.ssMergeCheckEqual(pa, depth, first2);
                }
                if ((check & 2) != 0) {
                    this.ssMergeCheckEqual(pa, depth, last2);
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first2 = entry.a;
                middle = entry.b;
                last2 = entry.c;
                check = entry.d;
                continue;
            }
            if (middle - first2 <= bufsize) {
                if (first2 < middle) {
                    this.ssMergeForward(pa, buf, bufoffset, first2, middle, last2, depth);
                }
                if ((check & 1) != 0) {
                    this.ssMergeCheckEqual(pa, depth, first2);
                }
                if ((check & 2) != 0) {
                    this.ssMergeCheckEqual(pa, depth, last2);
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first2 = entry.a;
                middle = entry.b;
                last2 = entry.c;
                check = entry.d;
                continue;
            }
            int m = 0;
            int len = Math.min(middle - first2, last2 - middle);
            int half = len >> 1;
            while (0 < len) {
                if (this.ssCompare(pa + Bzip2DivSufSort.getIDX(SA[middle + m + half]), pa + Bzip2DivSufSort.getIDX(SA[middle - m - half - 1]), depth) < 0) {
                    m += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (0 < m) {
                int j;
                Bzip2DivSufSort.ssBlockSwap(SA, middle - m, SA, middle, m);
                int i = j = middle;
                int next2 = 0;
                if (middle + m < last2) {
                    if (SA[middle + m] < 0) {
                        while (SA[i - 1] < 0) {
                            --i;
                        }
                        SA[middle + m] = ~SA[middle + m];
                    }
                    j = middle;
                    while (SA[j] < 0) {
                        ++j;
                    }
                    next2 = 1;
                }
                if (i - first2 <= last2 - j) {
                    stack[ssize++] = new StackEntry(j, middle + m, last2, check & 2 | next2 & 1);
                    middle -= m;
                    last2 = i;
                    check &= 1;
                    continue;
                }
                if (i == middle && middle == j) {
                    next2 <<= 1;
                }
                stack[ssize++] = new StackEntry(first2, middle - m, i, check & 1 | next2 & 2);
                first2 = j;
                middle += m;
                check = check & 2 | next2 & 1;
                continue;
            }
            if ((check & 1) != 0) {
                this.ssMergeCheckEqual(pa, depth, first2);
            }
            this.ssMergeCheckEqual(pa, depth, middle);
            if ((check & 2) != 0) {
                this.ssMergeCheckEqual(pa, depth, last2);
            }
            if (ssize == 0) {
                return;
            }
            entry = stack[--ssize];
            first2 = entry.a;
            middle = entry.b;
            last2 = entry.c;
            check = entry.d;
        }
    }

    private void subStringSort(int pa, int first2, int last2, int[] buf, int bufoffset, int bufsize, int depth, boolean lastsuffix, int size) {
        int k;
        int[] SA = this.SA;
        if (lastsuffix) {
            ++first2;
        }
        int a = first2;
        int i = 0;
        while (a + 1024 < last2) {
            this.ssMultiKeyIntroSort(pa, a, a + 1024, depth);
            int[] curbuf = SA;
            int curbufoffset = a + 1024;
            int curbufsize = last2 - (a + 1024);
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
                curbufoffset = bufoffset;
            }
            int b = a;
            k = 1024;
            int j = i;
            while ((j & 1) != 0) {
                this.ssMerge(pa, b - k, b, b + k, curbuf, curbufoffset, curbufsize, depth);
                b -= k;
                k <<= 1;
                j >>>= 1;
            }
            a += 1024;
            ++i;
        }
        this.ssMultiKeyIntroSort(pa, a, last2, depth);
        k = 1024;
        while (i != 0) {
            if (i & true) {
                this.ssMerge(pa, a - k, a, last2, buf, bufoffset, bufsize, depth);
                a -= k;
            }
            k <<= 1;
            i >>= 1;
        }
        if (lastsuffix) {
            i = SA[first2 - 1];
            int r = 1;
            for (a = first2; a < last2 && (SA[a] < 0 || 0 < (r = this.ssCompareLast(pa, pa + i, pa + SA[a], depth, size))); ++a) {
                SA[a - 1] = SA[a];
            }
            if (r == 0) {
                SA[a] = ~SA[a];
            }
            SA[a - 1] = i;
        }
    }

    private int trGetC(int isa, int isaD, int isaN, int p) {
        return isaD + p < isaN ? this.SA[isaD + p] : this.SA[isa + (isaD - isa + p) % (isaN - isa)];
    }

    private void trFixdown(int isa, int isaD, int isaN, int sa, int i, int size) {
        int j;
        int[] SA = this.SA;
        int v = SA[sa + i];
        int c = this.trGetC(isa, isaD, isaN, v);
        while ((j = 2 * i + 1) < size) {
            int e2;
            int k;
            int d;
            if ((d = this.trGetC(isa, isaD, isaN, SA[sa + (k = j++)])) < (e2 = this.trGetC(isa, isaD, isaN, SA[sa + j]))) {
                k = j;
                d = e2;
            }
            if (d <= c) break;
            SA[sa + i] = SA[sa + k];
            i = k;
        }
        SA[sa + i] = v;
    }

    private void trHeapSort(int isa, int isaD, int isaN, int sa, int size) {
        int i;
        int[] SA = this.SA;
        int m = size;
        if (size % 2 == 0 && this.trGetC(isa, isaD, isaN, SA[sa + --m / 2]) < this.trGetC(isa, isaD, isaN, SA[sa + m])) {
            Bzip2DivSufSort.swapElements(SA, sa + m, SA, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.trFixdown(isa, isaD, isaN, sa, i, m);
        }
        if (size % 2 == 0) {
            Bzip2DivSufSort.swapElements(SA, sa, SA, sa + m);
            this.trFixdown(isa, isaD, isaN, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = SA[sa];
            SA[sa] = SA[sa + i];
            this.trFixdown(isa, isaD, isaN, sa, 0, i);
            SA[sa + i] = t;
        }
    }

    private void trInsertionSort(int isa, int isaD, int isaN, int first2, int last2) {
        int[] SA = this.SA;
        for (int a = first2 + 1; a < last2; ++a) {
            int r;
            int t = SA[a];
            int b = a - 1;
            while (0 > (r = this.trGetC(isa, isaD, isaN, t) - this.trGetC(isa, isaD, isaN, SA[b]))) {
                do {
                    SA[b + 1] = SA[b];
                } while (first2 <= --b && SA[b] < 0);
                if (b >= first2) continue;
            }
            if (r == 0) {
                SA[b] = ~SA[b];
            }
            SA[b + 1] = t;
        }
    }

    private static int trLog(int n) {
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 + LOG_2_TABLE[n >> 24 & 0xFF] : LOG_2_TABLE[n >> 16 & 0x10F]) : ((n & 0xFF00) != 0 ? 8 + LOG_2_TABLE[n >> 8 & 0xFF] : LOG_2_TABLE[n & 0xFF]);
    }

    private int trMedian3(int isa, int isaD, int isaN, int v1, int v2, int v3) {
        int[] SA = this.SA;
        int SA_v1 = this.trGetC(isa, isaD, isaN, SA[v1]);
        int SA_v2 = this.trGetC(isa, isaD, isaN, SA[v2]);
        int SA_v3 = this.trGetC(isa, isaD, isaN, SA[v3]);
        if (SA_v1 > SA_v2) {
            int temp = v1;
            v1 = v2;
            v2 = temp;
            int SA_vtemp = SA_v1;
            SA_v1 = SA_v2;
            SA_v2 = SA_vtemp;
        }
        if (SA_v2 > SA_v3) {
            if (SA_v1 > SA_v3) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private int trMedian5(int isa, int isaD, int isaN, int v1, int v2, int v3, int v4, int v5) {
        int SA_vtemp;
        int temp;
        int[] SA = this.SA;
        int SA_v1 = this.trGetC(isa, isaD, isaN, SA[v1]);
        int SA_v2 = this.trGetC(isa, isaD, isaN, SA[v2]);
        int SA_v3 = this.trGetC(isa, isaD, isaN, SA[v3]);
        int SA_v4 = this.trGetC(isa, isaD, isaN, SA[v4]);
        int SA_v5 = this.trGetC(isa, isaD, isaN, SA[v5]);
        if (SA_v2 > SA_v3) {
            temp = v2;
            v2 = v3;
            v3 = temp;
            SA_vtemp = SA_v2;
            SA_v2 = SA_v3;
            SA_v3 = SA_vtemp;
        }
        if (SA_v4 > SA_v5) {
            temp = v4;
            v4 = v5;
            v5 = temp;
            SA_vtemp = SA_v4;
            SA_v4 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v2 > SA_v4) {
            v4 = temp = v2;
            SA_v4 = SA_vtemp = SA_v2;
            temp = v3;
            v3 = v5;
            v5 = temp;
            SA_vtemp = SA_v3;
            SA_v3 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v1 > SA_v3) {
            temp = v1;
            v1 = v3;
            v3 = temp;
            SA_vtemp = SA_v1;
            SA_v1 = SA_v3;
            SA_v3 = SA_vtemp;
        }
        if (SA_v1 > SA_v4) {
            v4 = temp = v1;
            SA_v4 = SA_vtemp = SA_v1;
            v3 = v5;
            SA_v3 = SA_v5;
        }
        if (SA_v3 > SA_v4) {
            return v4;
        }
        return v3;
    }

    private int trPivot(int isa, int isaD, int isaN, int first2, int last2) {
        int t = last2 - first2;
        int middle = first2 + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.trMedian3(isa, isaD, isaN, first2, middle, last2 - 1);
            }
            return this.trMedian5(isa, isaD, isaN, first2, first2 + (t >>= 2), middle, last2 - 1 - t, last2 - 1);
        }
        return this.trMedian3(isa, isaD, isaN, this.trMedian3(isa, isaD, isaN, first2, first2 + (t >>= 3), first2 + (t << 1)), this.trMedian3(isa, isaD, isaN, middle - t, middle, middle + t), this.trMedian3(isa, isaD, isaN, last2 - 1 - (t << 1), last2 - 1 - t, last2 - 1));
    }

    private void lsUpdateGroup(int isa, int first2, int last2) {
        int[] SA = this.SA;
        for (int a = first2; a < last2; ++a) {
            int b;
            if (0 <= SA[a]) {
                b = a;
                do {
                    SA[isa + SA[a]] = a;
                } while (++a < last2 && 0 <= SA[a]);
                SA[b] = b - a;
                if (last2 <= a) break;
            }
            b = a;
            do {
                SA[a] = ~SA[a];
            } while (SA[++a] < 0);
            int t = a;
            do {
                SA[isa + SA[b]] = t;
            } while (++b <= a);
        }
    }

    private void lsIntroSort(int isa, int isaD, int isaN, int first2, int last2) {
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit2 = Bzip2DivSufSort.trLog(last2 - first2);
        while (true) {
            int c;
            int b;
            int a;
            StackEntry entry;
            if (last2 - first2 <= 8) {
                if (1 < last2 - first2) {
                    this.trInsertionSort(isa, isaD, isaN, first2, last2);
                    this.lsUpdateGroup(isa, first2, last2);
                } else if (last2 - first2 == 1) {
                    SA[first2] = -1;
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first2 = entry.a;
                last2 = entry.b;
                limit2 = entry.c;
                continue;
            }
            if (limit2-- == 0) {
                this.trHeapSort(isa, isaD, isaN, first2, last2 - first2);
                a = last2 - 1;
                while (first2 < a) {
                    x = this.trGetC(isa, isaD, isaN, SA[a]);
                    for (b = a - 1; first2 <= b && this.trGetC(isa, isaD, isaN, SA[b]) == x; --b) {
                        SA[b] = ~SA[b];
                    }
                    a = b;
                }
                this.lsUpdateGroup(isa, first2, last2);
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first2 = entry.a;
                last2 = entry.b;
                limit2 = entry.c;
                continue;
            }
            a = this.trPivot(isa, isaD, isaN, first2, last2);
            Bzip2DivSufSort.swapElements(SA, first2, SA, a);
            int v = this.trGetC(isa, isaD, isaN, SA[first2]);
            for (b = first2 + 1; b < last2 && (x = this.trGetC(isa, isaD, isaN, SA[b])) == v; ++b) {
            }
            a = b;
            if (a < last2 && x < v) {
                while (++b < last2 && (x = this.trGetC(isa, isaD, isaN, SA[b])) <= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            for (c = last2 - 1; b < c && (x = this.trGetC(isa, isaD, isaN, SA[c])) == v; --c) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.trGetC(isa, isaD, isaN, SA[c])) >= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                Bzip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = this.trGetC(isa, isaD, isaN, SA[b])) <= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = this.trGetC(isa, isaD, isaN, SA[c])) >= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first2;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e2 = first2;
                int f = b - s;
                while (0 < s) {
                    Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                    --s;
                    ++e2;
                    ++f;
                }
                s = d - c;
                t = last2 - d - 1;
                if (s > t) {
                    s = t;
                }
                e2 = b;
                f = last2 - s;
                while (0 < s) {
                    Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                    --s;
                    ++e2;
                    ++f;
                }
                a = first2 + (b - a);
                b = last2 - (d - c);
                v = a - 1;
                for (c = first2; c < a; ++c) {
                    SA[isa + SA[c]] = v;
                }
                if (b < last2) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        SA[isa + SA[c]] = v;
                    }
                }
                if (b - a == 1) {
                    SA[a] = -1;
                }
                if (a - first2 <= last2 - b) {
                    if (first2 < a) {
                        stack[ssize++] = new StackEntry(b, last2, limit2, 0);
                        last2 = a;
                        continue;
                    }
                    first2 = b;
                    continue;
                }
                if (b < last2) {
                    stack[ssize++] = new StackEntry(first2, a, limit2, 0);
                    first2 = b;
                    continue;
                }
                last2 = a;
                continue;
            }
            if (ssize == 0) {
                return;
            }
            entry = stack[--ssize];
            first2 = entry.a;
            last2 = entry.b;
            limit2 = entry.c;
        }
    }

    private void lsSort(int isa, int n, int depth) {
        int[] SA = this.SA;
        int isaD = isa + depth;
        while (-n < SA[0]) {
            int last2;
            int t;
            int first2 = 0;
            int skip = 0;
            do {
                if ((t = SA[first2]) < 0) {
                    first2 -= t;
                    skip += t;
                    continue;
                }
                if (skip != 0) {
                    SA[first2 + skip] = skip;
                    skip = 0;
                }
                last2 = SA[isa + t] + 1;
                this.lsIntroSort(isa, isaD, isa + n, first2, last2);
                first2 = last2;
            } while (first2 < n);
            if (skip != 0) {
                SA[first2 + skip] = skip;
            }
            if (n < isaD - isa) {
                first2 = 0;
                do {
                    if ((t = SA[first2]) < 0) {
                        first2 -= t;
                        continue;
                    }
                    last2 = SA[isa + t] + 1;
                    for (int i = first2; i < last2; ++i) {
                        SA[isa + SA[i]] = i;
                    }
                    first2 = last2;
                } while (first2 < n);
                break;
            }
            isaD += isaD - isa;
        }
    }

    private PartitionResult trPartition(int isa, int isaD, int isaN, int first2, int last2, int v) {
        int c;
        int b;
        int[] SA = this.SA;
        int x = 0;
        for (b = first2; b < last2 && (x = this.trGetC(isa, isaD, isaN, SA[b])) == v; ++b) {
        }
        int a = b;
        if (a < last2 && x < v) {
            while (++b < last2 && (x = this.trGetC(isa, isaD, isaN, SA[b])) <= v) {
                if (x != v) continue;
                Bzip2DivSufSort.swapElements(SA, b, SA, a);
                ++a;
            }
        }
        for (c = last2 - 1; b < c && (x = this.trGetC(isa, isaD, isaN, SA[c])) == v; --c) {
        }
        int d = c;
        if (b < d && x > v) {
            while (b < --c && (x = this.trGetC(isa, isaD, isaN, SA[c])) >= v) {
                if (x != v) continue;
                Bzip2DivSufSort.swapElements(SA, c, SA, d);
                --d;
            }
        }
        while (b < c) {
            Bzip2DivSufSort.swapElements(SA, b, SA, c);
            while (++b < c && (x = this.trGetC(isa, isaD, isaN, SA[b])) <= v) {
                if (x != v) continue;
                Bzip2DivSufSort.swapElements(SA, b, SA, a);
                ++a;
            }
            while (b < --c && (x = this.trGetC(isa, isaD, isaN, SA[c])) >= v) {
                if (x != v) continue;
                Bzip2DivSufSort.swapElements(SA, c, SA, d);
                --d;
            }
        }
        if (a <= d) {
            c = b - 1;
            int s = a - first2;
            int t = b - a;
            if (s > t) {
                s = t;
            }
            int e2 = first2;
            int f = b - s;
            while (0 < s) {
                Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                --s;
                ++e2;
                ++f;
            }
            s = d - c;
            t = last2 - d - 1;
            if (s > t) {
                s = t;
            }
            e2 = b;
            f = last2 - s;
            while (0 < s) {
                Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                --s;
                ++e2;
                ++f;
            }
            first2 += b - a;
            last2 -= d - c;
        }
        return new PartitionResult(first2, last2);
    }

    private void trCopy(int isa, int isaN, int first2, int a, int b, int last2, int depth) {
        int s;
        int c;
        int[] SA = this.SA;
        int v = b - 1;
        int d = a - 1;
        for (c = first2; c <= d; ++c) {
            s = SA[c] - depth;
            if (s < 0) {
                s += isaN - isa;
            }
            if (SA[isa + s] != v) continue;
            SA[++d] = s;
            SA[isa + s] = d;
        }
        c = last2 - 1;
        int e2 = d + 1;
        d = b;
        while (e2 < d) {
            s = SA[c] - depth;
            if (s < 0) {
                s += isaN - isa;
            }
            if (SA[isa + s] == v) {
                SA[--d] = s;
                SA[isa + s] = d;
            }
            --c;
        }
    }

    private void trIntroSort(int isa, int isaD, int isaN, int first2, int last2, TRBudget budget, int size) {
        int s;
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit2 = Bzip2DivSufSort.trLog(last2 - first2);
        while (true) {
            int next2;
            StackEntry entry;
            int c;
            int v;
            int b;
            int a;
            if (limit2 < 0) {
                if (limit2 == -1) {
                    StackEntry entry2;
                    if (!budget.update(size, last2 - first2)) break;
                    PartitionResult result = this.trPartition(isa, isaD - 1, isaN, first2, last2, last2 - 1);
                    a = result.first;
                    b = result.last;
                    if (first2 < a || b < last2) {
                        if (a < last2) {
                            v = a - 1;
                            for (c = first2; c < a; ++c) {
                                SA[isa + SA[c]] = v;
                            }
                        }
                        if (b < last2) {
                            v = b - 1;
                            for (c = a; c < b; ++c) {
                                SA[isa + SA[c]] = v;
                            }
                        }
                        stack[ssize++] = new StackEntry(0, a, b, 0);
                        stack[ssize++] = new StackEntry(isaD - 1, first2, last2, -2);
                        if (a - first2 <= last2 - b) {
                            if (1 < a - first2) {
                                stack[ssize++] = new StackEntry(isaD, b, last2, Bzip2DivSufSort.trLog(last2 - b));
                                last2 = a;
                                limit2 = Bzip2DivSufSort.trLog(a - first2);
                                continue;
                            }
                            if (1 < last2 - b) {
                                first2 = b;
                                limit2 = Bzip2DivSufSort.trLog(last2 - b);
                                continue;
                            }
                            if (ssize == 0) {
                                return;
                            }
                            entry2 = stack[--ssize];
                            isaD = entry2.a;
                            first2 = entry2.b;
                            last2 = entry2.c;
                            limit2 = entry2.d;
                            continue;
                        }
                        if (1 < last2 - b) {
                            stack[ssize++] = new StackEntry(isaD, first2, a, Bzip2DivSufSort.trLog(a - first2));
                            first2 = b;
                            limit2 = Bzip2DivSufSort.trLog(last2 - b);
                            continue;
                        }
                        if (1 < a - first2) {
                            last2 = a;
                            limit2 = Bzip2DivSufSort.trLog(a - first2);
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        entry2 = stack[--ssize];
                        isaD = entry2.a;
                        first2 = entry2.b;
                        last2 = entry2.c;
                        limit2 = entry2.d;
                        continue;
                    }
                    for (c = first2; c < last2; ++c) {
                        SA[isa + SA[c]] = c;
                    }
                    if (ssize == 0) {
                        return;
                    }
                    entry2 = stack[--ssize];
                    isaD = entry2.a;
                    first2 = entry2.b;
                    last2 = entry2.c;
                    limit2 = entry2.d;
                    continue;
                }
                if (limit2 == -2) {
                    a = stack[--ssize].b;
                    b = stack[ssize].c;
                    this.trCopy(isa, isaN, first2, a, b, last2, isaD - isa);
                    if (ssize == 0) {
                        return;
                    }
                    entry = stack[--ssize];
                    isaD = entry.a;
                    first2 = entry.b;
                    last2 = entry.c;
                    limit2 = entry.d;
                    continue;
                }
                if (0 <= SA[first2]) {
                    a = first2;
                    do {
                        SA[isa + SA[a]] = a;
                    } while (++a < last2 && 0 <= SA[a]);
                    first2 = a;
                }
                if (first2 < last2) {
                    a = first2;
                    do {
                        SA[a] = ~SA[a];
                    } while (SA[++a] < 0);
                    int n = next2 = SA[isa + SA[a]] != SA[isaD + SA[a]] ? Bzip2DivSufSort.trLog(a - first2 + 1) : -1;
                    if (++a < last2) {
                        v = a - 1;
                        for (b = first2; b < a; ++b) {
                            SA[isa + SA[b]] = v;
                        }
                    }
                    if (a - first2 <= last2 - a) {
                        stack[ssize++] = new StackEntry(isaD, a, last2, -3);
                        ++isaD;
                        last2 = a;
                        limit2 = next2;
                        continue;
                    }
                    if (1 < last2 - a) {
                        stack[ssize++] = new StackEntry(isaD + 1, first2, a, next2);
                        first2 = a;
                        limit2 = -3;
                        continue;
                    }
                    ++isaD;
                    last2 = a;
                    limit2 = next2;
                    continue;
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                isaD = entry.a;
                first2 = entry.b;
                last2 = entry.c;
                limit2 = entry.d;
                continue;
            }
            if (last2 - first2 <= 8) {
                if (!budget.update(size, last2 - first2)) break;
                this.trInsertionSort(isa, isaD, isaN, first2, last2);
                limit2 = -3;
                continue;
            }
            if (limit2-- == 0) {
                if (!budget.update(size, last2 - first2)) break;
                this.trHeapSort(isa, isaD, isaN, first2, last2 - first2);
                a = last2 - 1;
                while (first2 < a) {
                    x = this.trGetC(isa, isaD, isaN, SA[a]);
                    for (b = a - 1; first2 <= b && this.trGetC(isa, isaD, isaN, SA[b]) == x; --b) {
                        SA[b] = ~SA[b];
                    }
                    a = b;
                }
                limit2 = -3;
                continue;
            }
            a = this.trPivot(isa, isaD, isaN, first2, last2);
            Bzip2DivSufSort.swapElements(SA, first2, SA, a);
            v = this.trGetC(isa, isaD, isaN, SA[first2]);
            for (b = first2 + 1; b < last2 && (x = this.trGetC(isa, isaD, isaN, SA[b])) == v; ++b) {
            }
            a = b;
            if (a < last2 && x < v) {
                while (++b < last2 && (x = this.trGetC(isa, isaD, isaN, SA[b])) <= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            for (c = last2 - 1; b < c && (x = this.trGetC(isa, isaD, isaN, SA[c])) == v; --c) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.trGetC(isa, isaD, isaN, SA[c])) >= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                Bzip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = this.trGetC(isa, isaD, isaN, SA[b])) <= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = this.trGetC(isa, isaD, isaN, SA[c])) >= v) {
                    if (x != v) continue;
                    Bzip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                s = a - first2;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e2 = first2;
                int f = b - s;
                while (0 < s) {
                    Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                    --s;
                    ++e2;
                    ++f;
                }
                s = d - c;
                t = last2 - d - 1;
                if (s > t) {
                    s = t;
                }
                e2 = b;
                f = last2 - s;
                while (0 < s) {
                    Bzip2DivSufSort.swapElements(SA, e2, SA, f);
                    --s;
                    ++e2;
                    ++f;
                }
                a = first2 + (b - a);
                b = last2 - (d - c);
                next2 = SA[isa + SA[a]] != v ? Bzip2DivSufSort.trLog(b - a) : -1;
                v = a - 1;
                for (c = first2; c < a; ++c) {
                    SA[isa + SA[c]] = v;
                }
                if (b < last2) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        SA[isa + SA[c]] = v;
                    }
                }
                if (a - first2 <= last2 - b) {
                    if (last2 - b <= b - a) {
                        if (1 < a - first2) {
                            stack[ssize++] = new StackEntry(isaD + 1, a, b, next2);
                            stack[ssize++] = new StackEntry(isaD, b, last2, limit2);
                            last2 = a;
                            continue;
                        }
                        if (1 < last2 - b) {
                            stack[ssize++] = new StackEntry(isaD + 1, a, b, next2);
                            first2 = b;
                            continue;
                        }
                        if (1 < b - a) {
                            ++isaD;
                            first2 = a;
                            last2 = b;
                            limit2 = next2;
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        entry = stack[--ssize];
                        isaD = entry.a;
                        first2 = entry.b;
                        last2 = entry.c;
                        limit2 = entry.d;
                        continue;
                    }
                    if (a - first2 <= b - a) {
                        if (1 < a - first2) {
                            stack[ssize++] = new StackEntry(isaD, b, last2, limit2);
                            stack[ssize++] = new StackEntry(isaD + 1, a, b, next2);
                            last2 = a;
                            continue;
                        }
                        if (1 < b - a) {
                            stack[ssize++] = new StackEntry(isaD, b, last2, limit2);
                            ++isaD;
                            first2 = a;
                            last2 = b;
                            limit2 = next2;
                            continue;
                        }
                        first2 = b;
                        continue;
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackEntry(isaD, b, last2, limit2);
                        stack[ssize++] = new StackEntry(isaD, first2, a, limit2);
                        ++isaD;
                        first2 = a;
                        last2 = b;
                        limit2 = next2;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(isaD, b, last2, limit2);
                    last2 = a;
                    continue;
                }
                if (a - first2 <= b - a) {
                    if (1 < last2 - b) {
                        stack[ssize++] = new StackEntry(isaD + 1, a, b, next2);
                        stack[ssize++] = new StackEntry(isaD, first2, a, limit2);
                        first2 = b;
                        continue;
                    }
                    if (1 < a - first2) {
                        stack[ssize++] = new StackEntry(isaD + 1, a, b, next2);
                        last2 = a;
                        continue;
                    }
                    if (1 < b - a) {
                        ++isaD;
                        first2 = a;
                        last2 = b;
                        limit2 = next2;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(isaD, first2, last2, limit2);
                    continue;
                }
                if (last2 - b <= b - a) {
                    if (1 < last2 - b) {
                        stack[ssize++] = new StackEntry(isaD, first2, a, limit2);
                        stack[ssize++] = new StackEntry(isaD + 1, a, b, next2);
                        first2 = b;
                        continue;
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackEntry(isaD, first2, a, limit2);
                        ++isaD;
                        first2 = a;
                        last2 = b;
                        limit2 = next2;
                        continue;
                    }
                    last2 = a;
                    continue;
                }
                if (1 < b - a) {
                    stack[ssize++] = new StackEntry(isaD, first2, a, limit2);
                    stack[ssize++] = new StackEntry(isaD, b, last2, limit2);
                    ++isaD;
                    first2 = a;
                    last2 = b;
                    limit2 = next2;
                    continue;
                }
                stack[ssize++] = new StackEntry(isaD, first2, a, limit2);
                first2 = b;
                continue;
            }
            if (!budget.update(size, last2 - first2)) break;
            ++limit2;
            ++isaD;
        }
        for (s = 0; s < ssize; ++s) {
            if (stack[s].d != -3) continue;
            this.lsUpdateGroup(isa, stack[s].b, stack[s].c);
        }
    }

    private void trSort(int isa, int n, int depth) {
        int[] SA = this.SA;
        int first2 = 0;
        if (-n < SA[0]) {
            TRBudget budget = new TRBudget(n, Bzip2DivSufSort.trLog(n) * 2 / 3 + 1);
            do {
                int t;
                if ((t = SA[first2]) < 0) {
                    first2 -= t;
                    continue;
                }
                int last2 = SA[isa + t] + 1;
                if (1 < last2 - first2) {
                    this.trIntroSort(isa, isa + depth, isa + n, first2, last2, budget, n);
                    if (budget.chance == 0) {
                        if (0 < first2) {
                            SA[0] = -first2;
                        }
                        this.lsSort(isa, n, depth);
                        break;
                    }
                }
                first2 = last2;
            } while (first2 < n);
        }
    }

    private static int BUCKET_B(int c0, int c1) {
        return c1 << 8 | c0;
    }

    private static int BUCKET_BSTAR(int c0, int c1) {
        return c0 << 8 | c1;
    }

    private int sortTypeBstar(int[] bucketA, int[] bucketB) {
        int c1;
        int t;
        int c0;
        int ti1;
        int i;
        byte[] T = this.T;
        int[] SA = this.SA;
        int n = this.n;
        int[] tempbuf = new int[256];
        boolean flag = true;
        for (i = 1; i < n; ++i) {
            if (T[i - 1] == T[i]) continue;
            if ((T[i - 1] & 0xFF) <= (T[i] & 0xFF)) break;
            flag = false;
            break;
        }
        i = n - 1;
        int m = n;
        int ti = T[i] & 0xFF;
        int t0 = T[0] & 0xFF;
        if (ti < t0 || T[i] == T[0] && flag) {
            if (!flag) {
                int n2 = Bzip2DivSufSort.BUCKET_BSTAR(ti, t0);
                bucketB[n2] = bucketB[n2] + 1;
                SA[--m] = i;
            } else {
                int n3 = Bzip2DivSufSort.BUCKET_B(ti, t0);
                bucketB[n3] = bucketB[n3] + 1;
            }
            --i;
            while (0 <= i && (ti = T[i] & 0xFF) <= (ti1 = T[i + 1] & 0xFF)) {
                int n4 = Bzip2DivSufSort.BUCKET_B(ti, ti1);
                bucketB[n4] = bucketB[n4] + 1;
                --i;
            }
        }
        while (0 <= i) {
            do {
                int n5 = T[i] & 0xFF;
                bucketA[n5] = bucketA[n5] + 1;
            } while (0 <= --i && (T[i] & 0xFF) >= (T[i + 1] & 0xFF));
            if (0 > i) continue;
            int n6 = Bzip2DivSufSort.BUCKET_BSTAR(T[i] & 0xFF, T[i + 1] & 0xFF);
            bucketB[n6] = bucketB[n6] + 1;
            SA[--m] = i--;
            while (0 <= i && (ti = T[i] & 0xFF) <= (ti1 = T[i + 1] & 0xFF)) {
                int n7 = Bzip2DivSufSort.BUCKET_B(ti, ti1);
                bucketB[n7] = bucketB[n7] + 1;
                --i;
            }
        }
        if ((m = n - m) == 0) {
            for (i = 0; i < n; ++i) {
                SA[i] = i;
            }
            return 0;
        }
        i = -1;
        int j = 0;
        for (c0 = 0; c0 < 256; ++c0) {
            t = i + bucketA[c0];
            bucketA[c0] = i + j;
            i = t + bucketB[Bzip2DivSufSort.BUCKET_B(c0, c0)];
            for (c1 = c0 + 1; c1 < 256; ++c1) {
                bucketB[c0 << 8 | c1] = j += bucketB[Bzip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                i += bucketB[Bzip2DivSufSort.BUCKET_B(c0, c1)];
            }
        }
        int PAb = n - m;
        int ISAb = m;
        i = m - 2;
        while (0 <= i) {
            t = SA[PAb + i];
            c0 = T[t] & 0xFF;
            c1 = T[t + 1] & 0xFF;
            int n8 = Bzip2DivSufSort.BUCKET_BSTAR(c0, c1);
            int n9 = bucketB[n8] - 1;
            bucketB[n8] = n9;
            SA[n9] = i--;
        }
        t = SA[PAb + m - 1];
        c0 = T[t] & 0xFF;
        c1 = T[t + 1] & 0xFF;
        int n10 = Bzip2DivSufSort.BUCKET_BSTAR(c0, c1);
        int n11 = bucketB[n10] - 1;
        bucketB[n10] = n11;
        SA[n11] = m - 1;
        int[] buf = SA;
        int bufoffset = m;
        int bufsize = n - 2 * m;
        if (bufsize <= 256) {
            buf = tempbuf;
            bufoffset = 0;
            bufsize = 256;
        }
        c0 = 255;
        j = m;
        while (0 < j) {
            for (c1 = 255; c0 < c1; --c1) {
                i = bucketB[Bzip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                if (1 < j - i) {
                    this.subStringSort(PAb, i, j, buf, bufoffset, bufsize, 2, SA[i] == m - 1, n);
                }
                j = i;
            }
            --c0;
        }
        for (i = m - 1; 0 <= i; --i) {
            if (0 <= SA[i]) {
                j = i;
                do {
                    SA[ISAb + SA[i]] = i;
                } while (0 <= --i && 0 <= SA[i]);
                SA[i + 1] = i - j;
                if (i <= 0) break;
            }
            j = i;
            do {
                SA[i] = ~SA[i];
                SA[ISAb + SA[i]] = j;
            } while (SA[--i] < 0);
            SA[ISAb + SA[i]] = j;
        }
        this.trSort(ISAb, m, 1);
        i = n - 1;
        j = m;
        if ((T[i] & 0xFF) < (T[0] & 0xFF) || T[i] == T[0] && flag) {
            if (!flag) {
                SA[SA[ISAb + --j]] = i;
            }
            --i;
            while (0 <= i && (T[i] & 0xFF) <= (T[i + 1] & 0xFF)) {
                --i;
            }
        }
        while (0 <= i) {
            --i;
            while (0 <= i && (T[i] & 0xFF) >= (T[i + 1] & 0xFF)) {
                --i;
            }
            if (0 > i) continue;
            SA[SA[ISAb + --j]] = i--;
            while (0 <= i && (T[i] & 0xFF) <= (T[i + 1] & 0xFF)) {
                --i;
            }
        }
        i = n - 1;
        int k = m - 1;
        for (c0 = 255; 0 <= c0; --c0) {
            for (c1 = 255; c0 < c1; --c1) {
                t = i - bucketB[Bzip2DivSufSort.BUCKET_B(c0, c1)];
                bucketB[Bzip2DivSufSort.BUCKET_B((int)c0, (int)c1)] = i + 1;
                i = t;
                j = bucketB[Bzip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                while (j <= k) {
                    SA[i] = SA[k];
                    --i;
                    --k;
                }
            }
            t = i - bucketB[Bzip2DivSufSort.BUCKET_B(c0, c0)];
            bucketB[Bzip2DivSufSort.BUCKET_B((int)c0, (int)c0)] = i + 1;
            if (c0 < 255) {
                bucketB[Bzip2DivSufSort.BUCKET_BSTAR((int)c0, (int)(c0 + 1))] = t + 1;
            }
            i = bucketA[c0];
        }
        return m;
    }

    private int constructBWT(int[] bucketA, int[] bucketB) {
        int c0;
        int s1;
        int s;
        int i;
        byte[] T = this.T;
        int[] SA = this.SA;
        int n = this.n;
        int t = 0;
        int c2 = 0;
        int orig = -1;
        for (int c1 = 254; 0 <= c1; --c1) {
            i = bucketB[Bzip2DivSufSort.BUCKET_BSTAR(c1, c1 + 1)];
            t = 0;
            c2 = -1;
            for (int j = bucketA[c1 + 1]; i <= j; --j) {
                s1 = s = SA[j];
                if (0 <= s) {
                    if (--s < 0) {
                        s = n - 1;
                    }
                    if ((c0 = T[s] & 0xFF) > c1) continue;
                    SA[j] = ~s1;
                    if (0 < s && (T[s - 1] & 0xFF) > c0) {
                        s ^= 0xFFFFFFFF;
                    }
                    if (c2 == c0) {
                        SA[--t] = s;
                        continue;
                    }
                    if (0 <= c2) {
                        bucketB[Bzip2DivSufSort.BUCKET_B((int)c2, (int)c1)] = t;
                    }
                    c2 = c0;
                    t = bucketB[Bzip2DivSufSort.BUCKET_B(c2, c1)] - 1;
                    SA[t] = s;
                    continue;
                }
                SA[j] = ~s;
            }
        }
        for (i = 0; i < n; ++i) {
            s1 = s = SA[i];
            if (0 <= s) {
                if (--s < 0) {
                    s = n - 1;
                }
                if ((c0 = T[s] & 0xFF) >= (T[s + 1] & 0xFF)) {
                    if (0 < s && (T[s - 1] & 0xFF) < c0) {
                        s ^= 0xFFFFFFFF;
                    }
                    if (c0 == c2) {
                        SA[++t] = s;
                    } else {
                        if (c2 != -1) {
                            bucketA[c2] = t;
                        }
                        c2 = c0;
                        t = bucketA[c2] + 1;
                        SA[t] = s;
                    }
                }
            } else {
                s1 ^= 0xFFFFFFFF;
            }
            if (s1 == 0) {
                SA[i] = T[n - 1];
                orig = i;
                continue;
            }
            SA[i] = T[s1 - 1];
        }
        return orig;
    }

    public int bwt() {
        int[] SA = this.SA;
        byte[] T = this.T;
        int n = this.n;
        int[] bucketA = new int[256];
        int[] bucketB = new int[65536];
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            SA[0] = T[0];
            return 0;
        }
        int m = this.sortTypeBstar(bucketA, bucketB);
        if (0 < m) {
            return this.constructBWT(bucketA, bucketB);
        }
        return 0;
    }

    private static class TRBudget {
        int budget;
        int chance;

        TRBudget(int budget, int chance) {
            this.budget = budget;
            this.chance = chance;
        }

        boolean update(int size, int n) {
            this.budget -= n;
            if (this.budget <= 0) {
                if (--this.chance == 0) {
                    return false;
                }
                this.budget += size;
            }
            return true;
        }
    }

    private static class PartitionResult {
        final int first;
        final int last;

        PartitionResult(int first2, int last2) {
            this.first = first2;
            this.last = last2;
        }
    }

    private static class StackEntry {
        final int a;
        final int b;
        final int c;
        final int d;

        StackEntry(int a, int b, int c, int d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }
}

