/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.network;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.network.ConsistentHash;
import io.mantisrx.common.network.HashFunction;
import io.mantisrx.common.network.WritableEndpoint;
import io.mantisrx.common.network.WritableEndpointConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSlotManager<T> {
    private static final String CLIENT_ID = "clientId";
    private static final Logger LOG = LoggerFactory.getLogger(ServerSlotManager.class);
    ConcurrentHashMap<String, SlotAssignmentManager<T>> slotManagerMap = new ConcurrentHashMap();
    private HashFunction hashAlgorithm;

    public ServerSlotManager(HashFunction hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public synchronized SlotAssignmentManager<T> registerServer(WritableEndpoint<T> node2, Map<String, List<String>> params) {
        SlotAssignmentManager<T> sam;
        LOG.info("Registering server.node: " + node2);
        String subId = this.getSubscriptionId(params);
        if (subId == null) {
            subId = node2.getSlotId();
        }
        if ((sam = this.slotManagerMap.get(subId)) == null) {
            LOG.info("Setting up new SlotAssignmentManager for sub: " + subId);
            sam = new SlotAssignmentManager(this.hashAlgorithm, subId);
            this.slotManagerMap.putIfAbsent(subId, sam);
        }
        sam.registerServer(node2);
        return sam;
    }

    public synchronized void deregisterServer(WritableEndpoint<T> node2, Map<String, List<String>> params) {
        SlotAssignmentManager<T> sam;
        String subId = this.getSubscriptionId(params);
        if (subId == null) {
            subId = node2.getSlotId();
        }
        if ((sam = this.slotManagerMap.get(subId)) != null) {
            sam.deregisterServer(node2);
            if (sam.isEmpty()) {
                this.slotManagerMap.remove(subId);
            }
        }
    }

    private String getSubscriptionId(Map<String, List<String>> queryParams) {
        List<String> subIdList;
        if (queryParams != null && !queryParams.isEmpty() && (subIdList = queryParams.get(CLIENT_ID)) != null && !subIdList.isEmpty()) {
            return subIdList.get(0);
        }
        return null;
    }

    public static class SlotAssignmentManager<T> {
        AtomicReference<ConsistentHash<WritableEndpoint<T>>> consistentHashRef = new AtomicReference();
        ConcurrentSkipListSet<WritableEndpoint<T>> nodeList = new ConcurrentSkipListSet();
        ConcurrentHashMap<String, Integer> connectionIdToSlotNumberMap = new ConcurrentHashMap();
        private String consumerJobId;
        private HashFunction hashAlgo;
        private Gauge nodesOnRing;

        public SlotAssignmentManager(HashFunction hashAlgo, String subId) {
            this.consumerJobId = subId;
            this.hashAlgo = hashAlgo;
            Metrics metrics = new Metrics.Builder().name("SlottingRing_" + this.consumerJobId).addGauge("nodeCount").build();
            metrics = MetricsRegistry.getInstance().registerAndGet(metrics);
            this.nodesOnRing = metrics.getGauge("nodeCount");
        }

        public synchronized boolean forceRegisterServer(WritableEndpoint<T> sn) {
            WritableEndpoint oldEndpoint;
            boolean removed;
            LOG.info("Ring: " + this.consumerJobId + " before force register: " + this.nodeList);
            boolean success2 = this.nodeList.add(sn);
            if (!success2 && (removed = this.nodeList.remove(oldEndpoint = (WritableEndpoint)this.nodeList.tailSet(sn, true).first()))) {
                success2 = this.nodeList.add(sn);
                LOG.info("Explicitly would have closed endpoint: " + oldEndpoint);
            }
            LOG.info("node " + sn + " add " + success2);
            LOG.info("Ring: " + this.consumerJobId + " after force register: " + this.nodeList);
            ConsistentHash<WritableEndpoint<T>> newConsistentHash = new ConsistentHash<WritableEndpoint<T>>(this.hashAlgo, new WritableEndpointConfiguration(), this.nodeList);
            this.consistentHashRef.set(newConsistentHash);
            this.nodesOnRing.set(this.nodeList.size());
            return success2;
        }

        public synchronized boolean registerServer(WritableEndpoint<T> sn) {
            LOG.info("Ring: " + this.consumerJobId + " before register: " + this.nodeList);
            boolean success2 = this.nodeList.add(sn);
            LOG.info("node " + sn + " add " + success2);
            LOG.info("Ring: " + this.consumerJobId + " after register: " + this.nodeList);
            ConsistentHash<WritableEndpoint<T>> newConsistentHash = new ConsistentHash<WritableEndpoint<T>>(this.hashAlgo, new WritableEndpointConfiguration(), this.nodeList);
            this.consistentHashRef.set(newConsistentHash);
            this.nodesOnRing.set(this.nodeList.size());
            return success2;
        }

        public synchronized boolean deregisterServer(WritableEndpoint<T> node2) {
            LOG.info("Ring: " + this.consumerJobId + " before deregister: " + this.nodeList);
            boolean success2 = this.nodeList.remove(node2);
            LOG.info("node " + node2 + " removed " + success2);
            LOG.info("Ring: " + this.consumerJobId + " after deregister: " + this.nodeList);
            if (!this.nodeList.isEmpty()) {
                ConsistentHash<WritableEndpoint<T>> newConsistentHash = new ConsistentHash<WritableEndpoint<T>>(this.hashAlgo, new WritableEndpointConfiguration(), this.nodeList);
                this.consistentHashRef.set(newConsistentHash);
            }
            this.nodesOnRing.set(this.nodeList.size());
            return success2;
        }

        public boolean filter(WritableEndpoint<T> node2, byte[] keyBytes) {
            if (this.nodeList.size() > 1) {
                return node2.equals(this.consistentHashRef.get().get(keyBytes));
            }
            return true;
        }

        public Collection<WritableEndpoint<T>> endpoints() {
            return this.nodeList;
        }

        public WritableEndpoint<T> lookup(byte[] keyBytes) {
            return this.consistentHashRef.get().get(keyBytes);
        }

        public boolean isEmpty() {
            return this.nodeList.isEmpty();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionIdToSlotNumberMap == null ? 0 : this.connectionIdToSlotNumberMap.hashCode());
            result = 31 * result + (this.consumerJobId == null ? 0 : this.consumerJobId.hashCode());
            result = 31 * result + (this.nodeList == null ? 0 : this.nodeList.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SlotAssignmentManager other = (SlotAssignmentManager)obj;
            if (this.connectionIdToSlotNumberMap == null ? other.connectionIdToSlotNumberMap != null : !this.connectionIdToSlotNumberMap.equals(other.connectionIdToSlotNumberMap)) {
                return false;
            }
            if (this.consumerJobId == null ? other.consumerJobId != null : !this.consumerJobId.equals(other.consumerJobId)) {
                return false;
            }
            return !(this.nodeList == null ? other.nodeList != null : !this.nodeList.equals(other.nodeList));
        }
    }
}

