/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.network;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

public final class HashAlgorithm
extends Enum<HashAlgorithm> {
    public static final /* enum */ HashAlgorithm CRC32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm KETAMA_HASH = new HashAlgorithm();
    private static final /* synthetic */ HashAlgorithm[] $VALUES;

    public static HashAlgorithm[] values() {
        return (HashAlgorithm[])$VALUES.clone();
    }

    public static HashAlgorithm valueOf(String name2) {
        return Enum.valueOf(HashAlgorithm.class, name2);
    }

    public static byte[] computeMd5(byte[] keyBytes) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("MD5 not supported", e2);
        }
        md5.reset();
        md5.update(keyBytes);
        return md5.digest();
    }

    public long hash(byte[] keyBytes) {
        long rv = 0L;
        switch (this) {
            case CRC32_HASH: {
                CRC32 crc32 = new CRC32();
                crc32.update(keyBytes);
                rv = crc32.getValue() >> 16 & 0x7FFFL;
                break;
            }
            case KETAMA_HASH: {
                byte[] bKey = HashAlgorithm.computeMd5(keyBytes);
                rv = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return rv & 0xFFFFFFFFL;
    }

    static {
        $VALUES = new HashAlgorithm[]{CRC32_HASH, KETAMA_HASH};
    }
}

