/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.base;

import io.mantisrx.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.com.google.common.base.CharMatcher;
import io.mantisrx.shaded.com.google.common.base.Enums;
import io.mantisrx.shaded.com.google.common.base.Optional;
import java.lang.ref.WeakReference;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref2 = Enums.getEnumConstants(enumClass).get(value);
        return ref2 == null ? Optional.absent() : Optional.of(enumClass.cast(ref2.get()));
    }
}

