/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.metrics;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import mantis.io.reactivex.netty.channel.ChannelMetricEventProvider;
import mantis.io.reactivex.netty.metrics.Clock;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BytesInspector
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(BytesInspector.class);
    private final MetricEventsSubject eventsSubject;
    private final ChannelMetricEventProvider metricEventProvider;

    public BytesInspector(MetricEventsSubject eventsSubject, ChannelMetricEventProvider metricEventProvider) {
        this.eventsSubject = eventsSubject;
        this.metricEventProvider = metricEventProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesRead((ByteBuf)msg);
            } else if (ByteBufHolder.class.isAssignableFrom(msg.getClass())) {
                ByteBufHolder holder = (ByteBufHolder)msg;
                this.publishBytesRead(holder.content());
            }
        }
        catch (Exception e2) {
            logger.warn("Failed to publish bytes read metrics event. This does *not* stop the pipeline processing.", e2);
        }
        finally {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
        try {
            if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((ByteBuf)msg).readableBytes(), promise2);
            } else if (ByteBufHolder.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((ByteBufHolder)msg).content().readableBytes(), promise2);
            } else if (FileRegion.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((FileRegion)msg).count(), promise2);
            }
        }
        catch (Exception e2) {
            logger.warn("Failed to publish bytes write metrics event. This does *not* stop the pipeline processing.", e2);
        }
        finally {
            super.write(ctx, msg, promise2);
        }
    }

    protected void publishBytesWritten(final long bytesToWrite, ChannelPromise promise2) {
        if (bytesToWrite <= 0L) {
            return;
        }
        final long startTimeMillis = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(this.metricEventProvider.getWriteStartEvent(), (Object)bytesToWrite);
        promise2.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future2) throws Exception {
                if (future2.isSuccess()) {
                    BytesInspector.this.eventsSubject.onEvent(BytesInspector.this.metricEventProvider.getWriteSuccessEvent(), Clock.onEndMillis(startTimeMillis), bytesToWrite);
                } else {
                    BytesInspector.this.eventsSubject.onEvent(BytesInspector.this.metricEventProvider.getWriteFailedEvent(), Clock.onEndMillis(startTimeMillis), future2.cause(), (Object)bytesToWrite);
                }
            }
        });
    }

    protected void publishBytesRead(ByteBuf byteBuf) {
        if (null != byteBuf) {
            this.eventsSubject.onEvent(this.metricEventProvider.getBytesReadEvent(), (Object)byteBuf.readableBytes());
        }
    }
}

