/*
 * Decompiled with CFR 0.152.
 */
package io.reactivx.mantis.operators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public class DoOnRequestOperator<T>
implements Observable.Operator<T, T> {
    private static final Logger logger = LoggerFactory.getLogger(DoOnRequestOperator.class);
    private final String name;

    public DoOnRequestOperator(String name2) {
        this.name = name2;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final RequestSubscriber<? super T> requestSubscriber = new RequestSubscriber<T>(child);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (n > 10000L) {
                    logger.info("DoOnRequest + " + DoOnRequestOperator.this.name + " Requested------>: " + n);
                }
                requestSubscriber.requestMore(n);
            }
        });
        return requestSubscriber;
    }

    static class RequestSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> child;
        boolean once = false;

        public RequestSubscriber(Subscriber<? super T> child) {
            super(child);
            this.child = child;
        }

        @Override
        public void onStart() {
            if (!this.once) {
                this.request(0L);
            }
        }

        void requestMore(long n) {
            this.once = true;
            this.request(n);
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
        }

        @Override
        public void onError(Throwable e2) {
            this.child.onError(e2);
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(t);
        }
    }
}

