/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.reactivex.mantis.network.push.ChunkProcessor;
import io.reactivex.mantis.network.push.Chunker;
import io.reactivex.mantis.network.push.ConnectionManager;
import io.reactivex.mantis.network.push.MonitoredQueue;
import io.reactivex.mantis.network.push.NamedThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimedChunker<T>
implements Callable<Void> {
    private static ThreadFactory namedFactory = new NamedThreadFactory("TimedChunkerGroup");
    private MonitoredQueue<T> buffer;
    private ChunkProcessor<T> processor;
    private ExecutorService timerPool = Executors.newSingleThreadExecutor(namedFactory);
    private int maxBufferLength;
    private int maxTimeMSec;
    private ConnectionManager<T> connectionManager;

    public TimedChunker(MonitoredQueue<T> buffer, int maxBufferLength, int maxTimeMSec, ChunkProcessor<T> processor, ConnectionManager<T> connectionManager) {
        this.maxBufferLength = maxBufferLength;
        this.maxTimeMSec = maxTimeMSec;
        this.buffer = buffer;
        this.processor = processor;
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        while (!this.stopCondition()) {
            T data2 = this.buffer.get();
            Future<Void> queryFuture = this.timerPool.submit(new Chunker<T>(this.processor, data2, this.buffer, this.maxBufferLength, this.connectionManager));
            try {
                queryFuture.get(this.maxTimeMSec, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e2) {
                queryFuture.cancel(true);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw e3;
            }
            catch (TimeoutException timeoutException) {}
            continue;
            finally {
                queryFuture.cancel(true);
            }
        }
        return null;
    }

    private boolean stopCondition() {
        return Thread.currentThread().isInterrupted();
    }
}

