/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.databind.module;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanDescription;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.Deserializers;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ArrayType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ClassKey;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleDeserializers
implements Deserializers,
Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings = null;
    protected boolean _hasEnumDeserializer = false;

    public SimpleDeserializers() {
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> desers) {
        this.addDeserializers(desers);
    }

    public <T> void addDeserializer(Class<T> forClass, JsonDeserializer<? extends T> deser) {
        ClassKey key2 = new ClassKey(forClass);
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(key2, deser);
        if (forClass == Enum.class) {
            this._hasEnumDeserializer = true;
        }
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> desers) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : desers.entrySet()) {
            Class<?> cls = entry.getKey();
            JsonDeserializer<?> deser = entry.getValue();
            this.addDeserializer(cls, deser);
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type2);
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        return this._find(type2);
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type2);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type2);
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        JsonDeserializer<?> deser = this._classMappings.get(new ClassKey(type2));
        if (deser == null && this._hasEnumDeserializer && type2.isEnum()) {
            deser = this._classMappings.get(new ClassKey(Enum.class));
        }
        return deser;
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> nodeType, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(nodeType));
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        return this._find(refType);
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type2, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type2);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type2, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type2);
    }

    private final JsonDeserializer<?> _find(JavaType type2) {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(type2.getRawClass()));
    }
}

