/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.internal.producers.SingleProducer;
import rx.internal.schedulers.EventLoopsScheduler;
import rx.observers.Subscribers;
import rx.plugins.RxJavaHooks;

public final class ScalarSynchronousObservable<T>
extends Observable<T> {
    final T t;
    static final boolean STRONG_MODE;

    static <T> Producer createProducer(Subscriber<? super T> s2, T v) {
        if (STRONG_MODE) {
            return new SingleProducer<T>(s2, v);
        }
        return new WeakSingleProducer<T>(s2, v);
    }

    public static <T> ScalarSynchronousObservable<T> create(T t) {
        return new ScalarSynchronousObservable<T>(t);
    }

    protected ScalarSynchronousObservable(T t) {
        super(RxJavaHooks.onCreate(new JustOnSubscribe<T>(t)));
        this.t = t;
    }

    public T get() {
        return this.t;
    }

    public Observable<T> scalarScheduleOn(final Scheduler scheduler) {
        Func1<Action0, Subscription> onSchedule;
        if (scheduler instanceof EventLoopsScheduler) {
            final EventLoopsScheduler els = (EventLoopsScheduler)scheduler;
            onSchedule = new Func1<Action0, Subscription>(){

                @Override
                public Subscription call(Action0 a) {
                    return els.scheduleDirect(a);
                }
            };
        } else {
            onSchedule = new Func1<Action0, Subscription>(){

                @Override
                public Subscription call(final Action0 a) {
                    final Scheduler.Worker w = scheduler.createWorker();
                    w.schedule(new Action0(){

                        @Override
                        public void call() {
                            try {
                                a.call();
                            }
                            finally {
                                w.unsubscribe();
                            }
                        }
                    });
                    return w;
                }
            };
        }
        return ScalarSynchronousObservable.unsafeCreate(new ScalarAsyncOnSubscribe<T>(this.t, onSchedule));
    }

    public <R> Observable<R> scalarFlatMap(final Func1<? super T, ? extends Observable<? extends R>> func) {
        return ScalarSynchronousObservable.unsafeCreate(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                Observable o = (Observable)func.call(ScalarSynchronousObservable.this.t);
                if (o instanceof ScalarSynchronousObservable) {
                    child.setProducer(ScalarSynchronousObservable.createProducer(child, ((ScalarSynchronousObservable)o).t));
                } else {
                    o.unsafeSubscribe(Subscribers.wrap(child));
                }
            }
        });
    }

    static {
        String wp = System.getProperty("rx.just.strong-mode", "false");
        STRONG_MODE = Boolean.valueOf(wp);
    }

    static final class WeakSingleProducer<T>
    implements Producer {
        final Subscriber<? super T> actual;
        final T value;
        boolean once;

        public WeakSingleProducer(Subscriber<? super T> actual, T value) {
            this.actual = actual;
            this.value = value;
        }

        @Override
        public void request(long n) {
            if (this.once) {
                return;
            }
            if (n < 0L) {
                throw new IllegalStateException("n >= required but it was " + n);
            }
            if (n == 0L) {
                return;
            }
            this.once = true;
            Subscriber<T> a = this.actual;
            if (a.isUnsubscribed()) {
                return;
            }
            T v = this.value;
            try {
                a.onNext(v);
            }
            catch (Throwable e2) {
                Exceptions.throwOrReport(e2, a, v);
                return;
            }
            if (a.isUnsubscribed()) {
                return;
            }
            a.onCompleted();
        }
    }

    static final class ScalarAsyncProducer<T>
    extends AtomicBoolean
    implements Producer,
    Action0 {
        private static final long serialVersionUID = -2466317989629281651L;
        final Subscriber<? super T> actual;
        final T value;
        final Func1<Action0, Subscription> onSchedule;

        public ScalarAsyncProducer(Subscriber<? super T> actual, T value, Func1<Action0, Subscription> onSchedule) {
            this.actual = actual;
            this.value = value;
            this.onSchedule = onSchedule;
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            if (n != 0L && this.compareAndSet(false, true)) {
                this.actual.add(this.onSchedule.call(this));
            }
        }

        @Override
        public void call() {
            Subscriber<T> a = this.actual;
            if (a.isUnsubscribed()) {
                return;
            }
            T v = this.value;
            try {
                a.onNext(v);
            }
            catch (Throwable e2) {
                Exceptions.throwOrReport(e2, a, v);
                return;
            }
            if (a.isUnsubscribed()) {
                return;
            }
            a.onCompleted();
        }

        @Override
        public String toString() {
            return "ScalarAsyncProducer[" + this.value + ", " + this.get() + "]";
        }
    }

    static final class ScalarAsyncOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        final T value;
        final Func1<Action0, Subscription> onSchedule;

        ScalarAsyncOnSubscribe(T value, Func1<Action0, Subscription> onSchedule) {
            this.value = value;
            this.onSchedule = onSchedule;
        }

        @Override
        public void call(Subscriber<? super T> s2) {
            s2.setProducer(new ScalarAsyncProducer<T>(s2, this.value, this.onSchedule));
        }
    }

    static final class JustOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        final T value;

        JustOnSubscribe(T value) {
            this.value = value;
        }

        @Override
        public void call(Subscriber<? super T> s2) {
            s2.setProducer(ScalarSynchronousObservable.createProducer(s2, this.value));
        }
    }
}

