/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public abstract class DeferredScalarSubscriber<T, R>
extends Subscriber<T> {
    protected final Subscriber<? super R> actual;
    protected boolean hasValue;
    protected R value;
    final AtomicInteger state;
    static final int NO_REQUEST_NO_VALUE = 0;
    static final int HAS_REQUEST_NO_VALUE = 1;
    static final int NO_REQUEST_HAS_VALUE = 2;
    static final int HAS_REQUEST_HAS_VALUE = 3;

    public DeferredScalarSubscriber(Subscriber<? super R> actual) {
        this.actual = actual;
        this.state = new AtomicInteger();
    }

    @Override
    public void onError(Throwable ex) {
        this.value = null;
        this.actual.onError(ex);
    }

    @Override
    public void onCompleted() {
        if (this.hasValue) {
            this.complete(this.value);
        } else {
            this.complete();
        }
    }

    protected final void complete() {
        this.actual.onCompleted();
    }

    protected final void complete(R value) {
        Subscriber<R> a = this.actual;
        do {
            int s2;
            if ((s2 = this.state.get()) == 2 || s2 == 3 || a.isUnsubscribed()) {
                return;
            }
            if (s2 == 1) {
                a.onNext(value);
                if (!a.isUnsubscribed()) {
                    a.onCompleted();
                }
                this.state.lazySet(3);
                return;
            }
            this.value = value;
        } while (!this.state.compareAndSet(0, 2));
    }

    final void downstreamRequest(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        if (n != 0L) {
            Subscriber<R> a = this.actual;
            do {
                int s2;
                if ((s2 = this.state.get()) == 1 || s2 == 3 || a.isUnsubscribed()) {
                    return;
                }
                if (s2 != 2) continue;
                if (this.state.compareAndSet(2, 3)) {
                    a.onNext(this.value);
                    if (!a.isUnsubscribed()) {
                        a.onCompleted();
                    }
                }
                return;
            } while (!this.state.compareAndSet(0, 1));
            return;
        }
    }

    @Override
    public final void setProducer(Producer p) {
        p.request(Long.MAX_VALUE);
    }

    public final void subscribeTo(Observable<? extends T> source2) {
        this.setupDownstream();
        source2.unsafeSubscribe(this);
    }

    final void setupDownstream() {
        Subscriber<R> a = this.actual;
        a.add(this);
        a.setProducer(new InnerProducer(this));
    }

    static final class InnerProducer
    implements Producer {
        final DeferredScalarSubscriber<?, ?> parent;

        public InnerProducer(DeferredScalarSubscriber<?, ?> parent) {
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            this.parent.downstreamRequest(n);
        }
    }
}

