/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.LogTableColumnFormatException;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationManager {
    private static final String CONFIG_FILE_NAME = "lf5_configuration.xml";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String SELECTED = "selected";
    private static final String EXPANDED = "expanded";
    private static final String CATEGORY = "category";
    private static final String FIRST_CATEGORY_NAME = "Categories";
    private static final String LEVEL = "level";
    private static final String COLORLEVEL = "colorlevel";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String COLUMN = "column";
    private static final String NDCTEXTFILTER = "searchtext";
    private LogBrokerMonitor _monitor = null;
    private LogTable _table = null;

    public ConfigurationManager(LogBrokerMonitor monitor, LogTable table2) {
        this._monitor = monitor;
        this._table = table2;
        this.load();
    }

    public void save() {
        CategoryExplorerModel model = this._monitor.getCategoryExplorerTree().getExplorerModel();
        CategoryNode root2 = model.getRootCategoryNode();
        StringBuffer xml2 = new StringBuffer(2048);
        this.openXMLDocument(xml2);
        this.openConfigurationXML(xml2);
        this.processLogRecordFilter(this._monitor.getNDCTextFilter(), xml2);
        this.processLogLevels(this._monitor.getLogLevelMenuItems(), xml2);
        this.processLogLevelColors(this._monitor.getLogLevelMenuItems(), LogLevel.getLogLevelColorMap(), xml2);
        this.processLogTableColumns(LogTableColumn.getLogTableColumns(), xml2);
        this.processConfigurationNode(root2, xml2);
        this.closeConfigurationXML(xml2);
        this.store(xml2.toString());
    }

    public void reset() {
        this.deleteConfigurationFile();
        this.collapseTree();
        this.selectAllNodes();
    }

    public static String treePathToString(TreePath path2) {
        StringBuffer sb = new StringBuffer();
        CategoryNode n = null;
        Object[] objects = path2.getPath();
        for (int i = 1; i < objects.length; ++i) {
            n = (CategoryNode)objects[i];
            if (i > 1) {
                sb.append(".");
            }
            sb.append(n.getTitle());
        }
        return sb.toString();
    }

    protected void load() {
        File file2 = new File(this.getFilename());
        if (file2.exists()) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc2 = docBuilder.parse(file2);
                this.processRecordFilter(doc2);
                this.processCategories(doc2);
                this.processLogLevels(doc2);
                this.processLogLevelColors(doc2);
                this.processLogTableColumns(doc2);
            }
            catch (Exception e2) {
                System.err.println("Unable process configuration file at " + this.getFilename() + ". Error Message=" + e2.getMessage());
            }
        }
    }

    protected void processRecordFilter(Document doc2) {
        NodeList nodeList = doc2.getElementsByTagName(NDCTEXTFILTER);
        Node n = nodeList.item(0);
        if (n == null) {
            return;
        }
        NamedNodeMap map2 = n.getAttributes();
        String text = this.getValue(map2, NAME);
        if (text == null || text.equals("")) {
            return;
        }
        this._monitor.setNDCLogRecordFilter(text);
    }

    protected void processCategories(Document doc2) {
        CategoryExplorerTree tree = this._monitor.getCategoryExplorerTree();
        CategoryExplorerModel model = tree.getExplorerModel();
        NodeList nodeList = doc2.getElementsByTagName(CATEGORY);
        NamedNodeMap map2 = nodeList.item(0).getAttributes();
        int j = this.getValue(map2, NAME).equalsIgnoreCase(FIRST_CATEGORY_NAME) ? 1 : 0;
        for (int i = nodeList.getLength() - 1; i >= j; --i) {
            Node n = nodeList.item(i);
            map2 = n.getAttributes();
            CategoryNode chnode = model.addCategory(new CategoryPath(this.getValue(map2, PATH)));
            chnode.setSelected(this.getValue(map2, SELECTED).equalsIgnoreCase("true"));
            if (this.getValue(map2, EXPANDED).equalsIgnoreCase("true")) {
                // empty if block
            }
            tree.expandPath(model.getTreePathToRoot(chnode));
        }
    }

    protected void processLogLevels(Document doc2) {
        NodeList nodeList = doc2.getElementsByTagName(LEVEL);
        Map menuItems = this._monitor.getLogLevelMenuItems();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            NamedNodeMap map2 = n.getAttributes();
            String name2 = this.getValue(map2, NAME);
            try {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)menuItems.get(LogLevel.valueOf(name2));
                item.setSelected(this.getValue(map2, SELECTED).equalsIgnoreCase("true"));
                continue;
            }
            catch (LogLevelFormatException e2) {
                // empty catch block
            }
        }
    }

    protected void processLogLevelColors(Document doc2) {
        NodeList nodeList = doc2.getElementsByTagName(COLORLEVEL);
        LogLevel.getLogLevelColorMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n == null) {
                return;
            }
            NamedNodeMap map2 = n.getAttributes();
            String name2 = this.getValue(map2, NAME);
            try {
                LogLevel level = LogLevel.valueOf(name2);
                int red2 = Integer.parseInt(this.getValue(map2, RED));
                int green = Integer.parseInt(this.getValue(map2, GREEN));
                int blue = Integer.parseInt(this.getValue(map2, BLUE));
                Color c = new Color(red2, green, blue);
                if (level == null) continue;
                level.setLogLevelColorMap(level, c);
                continue;
            }
            catch (LogLevelFormatException e2) {
                // empty catch block
            }
        }
    }

    protected void processLogTableColumns(Document doc2) {
        NodeList nodeList = doc2.getElementsByTagName(COLUMN);
        Map menuItems = this._monitor.getLogTableColumnMenuItems();
        ArrayList<LogTableColumn> selectedColumns = new ArrayList<LogTableColumn>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n == null) {
                return;
            }
            NamedNodeMap map2 = n.getAttributes();
            String name2 = this.getValue(map2, NAME);
            try {
                LogTableColumn column = LogTableColumn.valueOf(name2);
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)menuItems.get(column);
                item.setSelected(this.getValue(map2, SELECTED).equalsIgnoreCase("true"));
                if (item.isSelected()) {
                    selectedColumns.add(column);
                }
            }
            catch (LogTableColumnFormatException e2) {
                // empty catch block
            }
            if (selectedColumns.isEmpty()) {
                this._table.setDetailedView();
                continue;
            }
            this._table.setView(selectedColumns);
        }
    }

    protected String getValue(NamedNodeMap map2, String attr) {
        Node n = map2.getNamedItem(attr);
        return n.getNodeValue();
    }

    protected void collapseTree() {
        CategoryExplorerTree tree = this._monitor.getCategoryExplorerTree();
        for (int i = tree.getRowCount() - 1; i > 0; --i) {
            tree.collapseRow(i);
        }
    }

    protected void selectAllNodes() {
        CategoryExplorerModel model = this._monitor.getCategoryExplorerTree().getExplorerModel();
        CategoryNode root2 = model.getRootCategoryNode();
        Enumeration<TreeNode> all2 = root2.breadthFirstEnumeration();
        CategoryNode n = null;
        while (all2.hasMoreElements()) {
            n = (CategoryNode)all2.nextElement();
            n.setSelected(true);
        }
    }

    protected void store(String s2) {
        try {
            PrintWriter writer2 = new PrintWriter(new FileWriter(this.getFilename()));
            writer2.print(s2);
            writer2.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected void deleteConfigurationFile() {
        try {
            File f = new File(this.getFilename());
            if (f.exists()) {
                f.delete();
            }
        }
        catch (SecurityException e2) {
            System.err.println("Cannot delete " + this.getFilename() + " because a security violation occured.");
        }
    }

    protected String getFilename() {
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        return home + sep + "lf5" + sep + CONFIG_FILE_NAME;
    }

    private void processConfigurationNode(CategoryNode node2, StringBuffer xml2) {
        CategoryExplorerModel model = this._monitor.getCategoryExplorerTree().getExplorerModel();
        Enumeration<TreeNode> all2 = node2.breadthFirstEnumeration();
        CategoryNode n = null;
        while (all2.hasMoreElements()) {
            n = (CategoryNode)all2.nextElement();
            this.exportXMLElement(n, model.getTreePathToRoot(n), xml2);
        }
    }

    private void processLogLevels(Map logLevelMenuItems, StringBuffer xml2) {
        xml2.append("\t<loglevels>\r\n");
        Iterator it = logLevelMenuItems.keySet().iterator();
        while (it.hasNext()) {
            LogLevel level = (LogLevel)it.next();
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)logLevelMenuItems.get(level);
            this.exportLogLevelXMLElement(level.getLabel(), item.isSelected(), xml2);
        }
        xml2.append("\t</loglevels>\r\n");
    }

    private void processLogLevelColors(Map logLevelMenuItems, Map logLevelColors, StringBuffer xml2) {
        xml2.append("\t<loglevelcolors>\r\n");
        Iterator it = logLevelMenuItems.keySet().iterator();
        while (it.hasNext()) {
            LogLevel level = (LogLevel)it.next();
            Color color = (Color)logLevelColors.get(level);
            this.exportLogLevelColorXMLElement(level.getLabel(), color, xml2);
        }
        xml2.append("\t</loglevelcolors>\r\n");
    }

    private void processLogTableColumns(List logTableColumnMenuItems, StringBuffer xml2) {
        xml2.append("\t<logtablecolumns>\r\n");
        Iterator it = logTableColumnMenuItems.iterator();
        while (it.hasNext()) {
            LogTableColumn column = (LogTableColumn)it.next();
            JCheckBoxMenuItem item = this._monitor.getTableColumnMenuItem(column);
            this.exportLogTableColumnXMLElement(column.getLabel(), item.isSelected(), xml2);
        }
        xml2.append("\t</logtablecolumns>\r\n");
    }

    private void processLogRecordFilter(String text, StringBuffer xml2) {
        xml2.append("\t<").append(NDCTEXTFILTER).append(" ");
        xml2.append(NAME).append("=\"").append(text).append("\"");
        xml2.append("/>\r\n");
    }

    private void openXMLDocument(StringBuffer xml2) {
        xml2.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
    }

    private void openConfigurationXML(StringBuffer xml2) {
        xml2.append("<configuration>\r\n");
    }

    private void closeConfigurationXML(StringBuffer xml2) {
        xml2.append("</configuration>\r\n");
    }

    private void exportXMLElement(CategoryNode node2, TreePath path2, StringBuffer xml2) {
        CategoryExplorerTree tree = this._monitor.getCategoryExplorerTree();
        xml2.append("\t<").append(CATEGORY).append(" ");
        xml2.append(NAME).append("=\"").append(node2.getTitle()).append("\" ");
        xml2.append(PATH).append("=\"").append(ConfigurationManager.treePathToString(path2)).append("\" ");
        xml2.append(EXPANDED).append("=\"").append(tree.isExpanded(path2)).append("\" ");
        xml2.append(SELECTED).append("=\"").append(node2.isSelected()).append("\"/>\r\n");
    }

    private void exportLogLevelXMLElement(String label, boolean selected, StringBuffer xml2) {
        xml2.append("\t\t<").append(LEVEL).append(" ").append(NAME);
        xml2.append("=\"").append(label).append("\" ");
        xml2.append(SELECTED).append("=\"").append(selected);
        xml2.append("\"/>\r\n");
    }

    private void exportLogLevelColorXMLElement(String label, Color color, StringBuffer xml2) {
        xml2.append("\t\t<").append(COLORLEVEL).append(" ").append(NAME);
        xml2.append("=\"").append(label).append("\" ");
        xml2.append(RED).append("=\"").append(color.getRed()).append("\" ");
        xml2.append(GREEN).append("=\"").append(color.getGreen()).append("\" ");
        xml2.append(BLUE).append("=\"").append(color.getBlue());
        xml2.append("\"/>\r\n");
    }

    private void exportLogTableColumnXMLElement(String label, boolean selected, StringBuffer xml2) {
        xml2.append("\t\t<").append(COLUMN).append(" ").append(NAME);
        xml2.append("=\"").append(label).append("\" ");
        xml2.append(SELECTED).append("=\"").append(selected);
        xml2.append("\"/>\r\n");
    }
}

