/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class ReassignIds
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema sourceSchema;
    private Type sourceType;

    ReassignIds(Schema sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type schema(Schema schema, Supplier<Type> future2) {
        this.sourceType = this.sourceSchema.asStruct();
        try {
            Type type2 = future2.get();
            return type2;
        }
        finally {
            this.sourceType = null;
        }
    }

    @Override
    public Type struct(Types.StructType struct2, Iterable<Type> fieldTypes) {
        Preconditions.checkNotNull(this.sourceType, "Evaluation must start with a schema.");
        Preconditions.checkArgument(this.sourceType.isStructType(), "Not a struct: %s", (Object)this.sourceType);
        Types.StructType sourceStruct = this.sourceType.asStructType();
        List<Types.NestedField> fields = struct2.fields();
        int length = fields.size();
        ArrayList<Type> types = Lists.newArrayList(fieldTypes);
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(length);
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            int sourceFieldId = sourceStruct.field(field.name()).fieldId();
            if (field.isRequired()) {
                newFields.add(Types.NestedField.required(sourceFieldId, field.name(), (Type)types.get(i), field.doc()));
                continue;
            }
            newFields.add(Types.NestedField.optional(sourceFieldId, field.name(), (Type)types.get(i), field.doc()));
        }
        return Types.StructType.of(newFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type field(Types.NestedField field, Supplier<Type> future2) {
        Preconditions.checkArgument(this.sourceType.isStructType(), "Not a struct: %s", (Object)this.sourceType);
        Types.StructType sourceStruct = this.sourceType.asStructType();
        Types.NestedField sourceField = sourceStruct.field(field.name());
        if (sourceField == null) {
            throw new IllegalArgumentException("Field " + field.name() + " not found in source schema");
        }
        this.sourceType = sourceField.type();
        try {
            Type type2 = future2.get();
            return type2;
        }
        finally {
            this.sourceType = sourceStruct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type list(Types.ListType list, Supplier<Type> elementTypeFuture) {
        Preconditions.checkArgument(this.sourceType.isListType(), "Not a list: %s", (Object)this.sourceType);
        Types.ListType sourceList = this.sourceType.asListType();
        int sourceElementId = sourceList.elementId();
        this.sourceType = sourceList.elementType();
        try {
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional(sourceElementId, elementTypeFuture.get());
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired(sourceElementId, elementTypeFuture.get());
            return listType;
        }
        finally {
            this.sourceType = sourceList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type map(Types.MapType map2, Supplier<Type> keyTypeFuture, Supplier<Type> valueTypeFuture) {
        Preconditions.checkArgument(this.sourceType.isMapType(), "Not a map: %s", (Object)this.sourceType);
        Types.MapType sourceMap = this.sourceType.asMapType();
        int sourceKeyId = sourceMap.keyId();
        int sourceValueId = sourceMap.valueId();
        try {
            this.sourceType = sourceMap.keyType();
            Type keyType = keyTypeFuture.get();
            this.sourceType = sourceMap.valueType();
            Type valueType = valueTypeFuture.get();
            if (map2.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional(sourceKeyId, sourceValueId, keyType, valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired(sourceKeyId, sourceValueId, keyType, valueType);
            return mapType;
        }
        finally {
            this.sourceType = sourceMap;
        }
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

