/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.types.Type;

public class Transforms {
    private static final Pattern HAS_WIDTH = Pattern.compile("(\\w+)\\[(\\d+)\\]");

    private Transforms() {
    }

    public static Transform<?, ?> fromString(Type type2, String transform2) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transform2);
        if (widthMatcher.matches()) {
            String name2 = widthMatcher.group(1);
            int parsedWidth = Integer.parseInt(widthMatcher.group(2));
            if (name2.equalsIgnoreCase("truncate")) {
                return Truncate.get(type2, parsedWidth);
            }
            if (name2.equals("bucket")) {
                return Bucket.get(type2, parsedWidth);
            }
        }
        if (transform2.equalsIgnoreCase("identity")) {
            return Identity.get(type2);
        }
        try {
            if (type2.typeId() == Type.TypeID.TIMESTAMP) {
                return Timestamps.valueOf(transform2.toUpperCase(Locale.ENGLISH));
            }
            if (type2.typeId() == Type.TypeID.DATE) {
                return Dates.valueOf(transform2.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new UnknownTransform(type2, transform2);
    }

    public static <T> Transform<T, T> identity(Type type2) {
        return Identity.get(type2);
    }

    public static <T> Transform<T, Integer> year(Type type2) {
        switch (type2.typeId()) {
            case DATE: {
                return Dates.YEAR;
            }
            case TIMESTAMP: {
                return Timestamps.YEAR;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type2 + " by year");
    }

    public static <T> Transform<T, Integer> month(Type type2) {
        switch (type2.typeId()) {
            case DATE: {
                return Dates.MONTH;
            }
            case TIMESTAMP: {
                return Timestamps.MONTH;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type2 + " by month");
    }

    public static <T> Transform<T, Integer> day(Type type2) {
        switch (type2.typeId()) {
            case DATE: {
                return Dates.DAY;
            }
            case TIMESTAMP: {
                return Timestamps.DAY;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type2 + " by day");
    }

    public static <T> Transform<T, Integer> hour(Type type2) {
        Preconditions.checkArgument(type2.typeId() == Type.TypeID.TIMESTAMP, "Cannot partition type %s by hour", (Object)type2);
        return Timestamps.HOUR;
    }

    public static <T> Transform<T, Integer> bucket(Type type2, int numBuckets) {
        return Bucket.get(type2, numBuckets);
    }

    public static <T> Transform<T, T> truncate(Type type2, int width) {
        return Truncate.get(type2, width);
    }
}

