/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;

public interface PartitionSpecVisitor<T> {
    public T identity(String var1, int var2);

    public T bucket(String var1, int var2, int var3);

    public T truncate(String var1, int var2, int var3);

    public T year(String var1, int var2);

    public T month(String var1, int var2);

    public T day(String var1, int var2);

    public T hour(String var1, int var2);

    public static <R> List<R> visit(Schema schema, PartitionSpec spec, PartitionSpecVisitor<R> visitor) {
        ArrayList<R> results = Lists.newArrayListWithExpectedSize(spec.fields().size());
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            Transform<?, ?> transform2 = field.transform();
            if (transform2 instanceof Identity) {
                results.add(visitor.identity(sourceName, field.sourceId()));
                continue;
            }
            if (transform2 instanceof Bucket) {
                results.add(visitor.bucket(sourceName, field.sourceId(), ((Bucket)transform2).numBuckets()));
                continue;
            }
            if (transform2 instanceof Truncate) {
                results.add(visitor.truncate(sourceName, field.sourceId(), ((Truncate)transform2).width()));
                continue;
            }
            if (transform2 == Dates.YEAR || transform2 == Timestamps.YEAR) {
                results.add(visitor.year(sourceName, field.sourceId()));
                continue;
            }
            if (transform2 == Dates.MONTH || transform2 == Timestamps.MONTH) {
                results.add(visitor.month(sourceName, field.sourceId()));
                continue;
            }
            if (transform2 == Dates.DAY || transform2 == Timestamps.DAY) {
                results.add(visitor.day(sourceName, field.sourceId()));
                continue;
            }
            if (transform2 != Timestamps.HOUR) continue;
            results.add(visitor.hour(sourceName, field.sourceId()));
        }
        return results;
    }
}

