/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Literals;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Predicate;
import org.apache.iceberg.types.Types;

public class UnboundPredicate<T>
extends Predicate<T, NamedReference> {
    UnboundPredicate(Expression.Operation op, NamedReference namedRef, T value) {
        super(op, namedRef, Literals.from(value));
    }

    UnboundPredicate(Expression.Operation op, NamedReference namedRef) {
        super(op, namedRef, null);
    }

    UnboundPredicate(Expression.Operation op, NamedReference namedRef, Literal<T> lit) {
        super(op, namedRef, lit);
    }

    @Override
    public Expression negate() {
        return new UnboundPredicate(this.op().negate(), (NamedReference)this.ref(), this.literal());
    }

    Expression bind(Types.StructType struct2) {
        return this.bind(struct2, true);
    }

    public Expression bind(Types.StructType struct2, boolean caseSensitive) {
        Schema schema = new Schema(struct2.fields());
        Types.NestedField field = caseSensitive ? schema.findField(((NamedReference)this.ref()).name()) : schema.caseInsensitiveFindField(((NamedReference)this.ref()).name());
        ValidationException.check(field != null, "Cannot find field '%s' in struct: %s", ((NamedReference)this.ref()).name(), schema.asStruct());
        if (this.literal() == null) {
            switch (this.op()) {
                case IS_NULL: {
                    if (field.isRequired()) {
                        return Expressions.alwaysFalse();
                    }
                    return new BoundPredicate(Expression.Operation.IS_NULL, new BoundReference(field.fieldId(), schema.accessorForField(field.fieldId())));
                }
                case NOT_NULL: {
                    if (field.isRequired()) {
                        return Expressions.alwaysTrue();
                    }
                    return new BoundPredicate(Expression.Operation.NOT_NULL, new BoundReference(field.fieldId(), schema.accessorForField(field.fieldId())));
                }
            }
            throw new ValidationException("Operation must be IS_NULL or NOT_NULL", new Object[0]);
        }
        Literal lit = this.literal().to(field.type());
        if (lit == null) {
            throw new ValidationException(String.format("Invalid value for comparison inclusive type %s: %s (%s)", field.type(), this.literal().value(), this.literal().value().getClass().getName()), new Object[0]);
        }
        if (lit == Literals.aboveMax()) {
            switch (this.op()) {
                case LT: 
                case LT_EQ: 
                case NOT_EQ: {
                    return Expressions.alwaysTrue();
                }
                case GT: 
                case GT_EQ: 
                case EQ: {
                    return Expressions.alwaysFalse();
                }
            }
        } else if (lit == Literals.belowMin()) {
            switch (this.op()) {
                case NOT_EQ: 
                case GT: 
                case GT_EQ: {
                    return Expressions.alwaysTrue();
                }
                case LT: 
                case LT_EQ: 
                case EQ: {
                    return Expressions.alwaysFalse();
                }
            }
        }
        return new BoundPredicate(this.op(), new BoundReference(field.fieldId(), schema.accessorForField(field.fieldId())), lit);
    }
}

