/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;

public class StrictMetricsEvaluator {
    private final Schema schema;
    private final Types.StructType struct;
    private final Expression expr;
    private transient ThreadLocal<MetricsEvalVisitor> visitors = null;
    private static final boolean ROWS_MUST_MATCH = true;
    private static final boolean ROWS_MIGHT_NOT_MATCH = false;

    private MetricsEvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new MetricsEvalVisitor());
        }
        return this.visitors.get();
    }

    public StrictMetricsEvaluator(Schema schema, Expression unbound) {
        this.schema = schema;
        this.struct = schema.asStruct();
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(unbound), true);
    }

    public boolean eval(DataFile file2) {
        return this.visitor().eval(file2);
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(DataFile file2) {
            if (file2.recordCount() <= 0L) {
                return true;
            }
            this.valueCounts = file2.valueCounts();
            this.nullCounts = file2.nullValueCounts();
            this.lowerBounds = file2.lowerBounds();
            this.upperBounds = file2.upperBounds();
            return ExpressionVisitors.visitEvaluator(StrictMetricsEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref2) {
            Integer id = ref2.fieldId();
            Preconditions.checkNotNull(StrictMetricsEvaluator.this.struct.field(id), "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.containsNullsOnly(id)) {
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref2) {
            Integer id = ref2.fieldId();
            Preconditions.checkNotNull(StrictMetricsEvaluator.this.struct.field(id), "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.nullCounts != null && this.nullCounts.containsKey(id) && this.nullCounts.get(id) == 0L) {
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(field.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(field.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref2, Literal<T> lit) {
            Integer id = ref2.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id) && this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(StrictMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp != 0) {
                    return false;
                }
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp != 0) {
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref2, Literal<T> lit) {
            int cmp;
            Integer id = ref2.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.containsNullsOnly(id)) {
                return true;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(StrictMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return true;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref2, Literal<T> lit) {
            return false;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref2, Literal<T> lit) {
            return false;
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref2, Literal<T> lit) {
            return false;
        }

        private boolean canContainNulls(Integer id) {
            return this.nullCounts == null || this.nullCounts.containsKey(id) && this.nullCounts.get(id) > 0L;
        }

        private boolean containsNullsOnly(Integer id) {
            return this.valueCounts != null && this.valueCounts.containsKey(id) && this.nullCounts != null && this.nullCounts.containsKey(id) && this.valueCounts.get(id) - this.nullCounts.get(id) == 0L;
        }
    }
}

